
// audio.h [pengine]

// Copyright 2004-2006 Jasmine Langridge, jaz at positro.net
// License: GPL version 2 (see included gpl.txt)



class PSSAudio : public PSubsystem {
private:
    PResourceList<PAudioSample> samplist;

public:
    PSSAudio(PApp &parentApp);
    ~PSSAudio();

    // TODO: tick

    PAudioSample *loadSample(const std::string &name, bool positional3D = true);
};

class PAudioSample : public PResource {
private:
    //uint32 buffer;
    unsigned int buffer; // not sure, maybe this will aid x86_64 portability

public:
    PAudioSample(const std::string &filename, bool positional3D = false);
    ~PAudioSample() { unload(); }

    void unload();

    friend class PAudioInstance;
};

class PAudioInstance {
private:
    PAudioSample *samp;
    //uint32 source;
    //uint32 reserved1;
    unsigned int source;
    unsigned int reserved1;

public:
    PAudioInstance(PAudioSample *_samp, bool looping = false);
    ~PAudioInstance();

    void update(const vec3f &pos, const vec3f &vel);
    void setGain(float gain); // 0-1
    void setHalfDistance(float lambda);
    void setPitch(float pitch); // 1 is normal

    void play();
    void stop();
    bool isPlaying();
};



