/* @HEADER@ */
// ************************************************************************
// 
//                              Sundance
//                 Copyright (2005) Sandia Corporation
// 
// Copyright (year first published) Sandia Corporation.  Under the terms 
// of Contract DE-AC04-94AL85000 with Sandia Corporation, the U.S. Government 
// retains certain rights in this software.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//                                                                                 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA                                                                                
// Questions? Contact Kevin Long (krlong@sandia.gov), 
// Sandia National Laboratories, Livermore, California, USA
// 
// ************************************************************************
/* @HEADER@ */

#ifndef SUNDANCE_STRINGEVALMEDIATOR_H
#define SUNDANCE_STRINGEVALMEDIATOR_H

#ifndef DOXYGEN_DEVELOPER_ONLY

#include "SundanceDefs.hpp"
#include "SundanceAbstractEvalMediator.hpp"


namespace SundanceCore
{
  using namespace SundanceUtils;
  class CoordExpr;
  class CellDiameterExpr;

  
  namespace Internal 
  {
    class MultiIndex; 
    class DiscreteFuncElement;
  }

  using namespace Internal;

  namespace Internal
    {
      /**
       *
       */
      class StringEvalMediator : public AbstractEvalMediator
        {
        public:
          /** */
          StringEvalMediator();

          /** */
          virtual ~StringEvalMediator(){;}

          /** Evaluate the given coordinate expression, putting
           * its numerical values in the given LoadableVector. */
          virtual void evalCoordExpr(const CoordExpr* expr,
                                     RefCountPtr<EvalVector>& vec) const ;

          /** Evaluate the given discrete function, putting
           * its numerical values in the given LoadableVector. */
          virtual void evalDiscreteFuncElement(const DiscreteFuncElement* expr,
                                               const Array<MultiIndex>& mi,
                                               Array<RefCountPtr<EvalVector> >& vec) const ;

          /** Evaluate the given cell diameter expression, putting
           * its numerical values in the given EvalVector. */
          virtual void evalCellDiameterExpr(const CellDiameterExpr* expr,
                                            RefCountPtr<EvalVector>& vec) const ;

	  /** Evaluate the given cell vector expression, putting
	   * its numerical values in the given EvalVector. */
	  virtual void evalCellVectorExpr(const CellVectorExpr* expr,
					  RefCountPtr<EvalVector>& vec) const ;
            

        };
    }
}


#endif /* DOXYGEN_DEVELOPER_ONLY */
#endif
