// $Id: LOCA_Hopf_MinimallyAugmented_FiniteDifferenceGroup.H,v 1.1 2007/02/12 23:11:50 etphipp Exp $ 
// $Source: /space/CVS/Trilinos/packages/nox/src-loca/src/LOCA_Hopf_MinimallyAugmented_FiniteDifferenceGroup.H,v $ 

//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source: /space/CVS/Trilinos/packages/nox/src-loca/src/LOCA_Hopf_MinimallyAugmented_FiniteDifferenceGroup.H,v $
//  $Author: etphipp $
//  $Date: 2007/02/12 23:11:50 $
//  $Revision: 1.1 $
// ************************************************************************
//@HEADER

#ifndef LOCA_HOPF_MINIMALLYAUGMENTED_FINITEDIFFERENCEGROUP_H
#define LOCA_HOPF_MINIMALLYAUGMENTED_FINITEDIFFERENCEGROUP_H

#include "LOCA_Hopf_MinimallyAugmented_AbstractGroup.H"   // base class
#include "LOCA_Hopf_MooreSpence_FiniteDifferenceGroup.H"  // base class

namespace LOCA { 
  
  namespace Hopf { 

    namespace MinimallyAugmented {

      /*!  
       * \brief Concrete class that provides concrete implementations of the
       * derivative computation methods of the 
       * LOCA::Hopf::MinimallyAugmented::AbstractGroup using 
       * first-order finite differencing.
       */
      /*! 
       * The finite-differencing calculations are actually implemented by
       * the LOCA::DerivUtils class, and a custom DerivUtils object can be
       * passed through the constructor of this class.  However, in the future
       * the calculations encapsulated in the DerivUtils class may be 
       * incorporated directly into this class and other finite-differencing
       * child classes.
       */
      class FiniteDifferenceGroup : 
	public virtual LOCA::Hopf::MinimallyAugmented::AbstractGroup,
	public virtual LOCA::Hopf::MooreSpence::FiniteDifferenceGroup {

      public:
  
	//! Constructor.
	FiniteDifferenceGroup();
 
	//! Copy constructor
	FiniteDifferenceGroup(const FiniteDifferenceGroup& source, 
			      NOX::CopyType type = NOX::DeepCopy);

	//! Destructor
	virtual ~FiniteDifferenceGroup();

	/*! 
	 * \brief Computes the derivative \f$\partial w^TCe/\partial p\f$ 
	 */
	/*! 
	 * The calculation is implemented by calling the corresponding
	 * LOCA::DerivUtils::computeDwtCeDp() method of the passed 
	 * LOCA::DerivUtils object.
	 */
	virtual NOX::Abstract::Group::ReturnType 
	computeDwtCeDp(const vector<int>& paramIDs, 
		       const NOX::Abstract::Vector& w1,
		       const NOX::Abstract::Vector& w2,
		       const NOX::Abstract::Vector& y,
		       const NOX::Abstract::Vector& x,
		       double omega,
		       NOX::Abstract::MultiVector::DenseMatrix& result_real,
		       NOX::Abstract::MultiVector::DenseMatrix& result_imag,
		       bool isValid);

	/*! 
	 * \brief Computes the derivative 
	 * \f$\frac{\partial w^TCe}{\partial x}\f$. 
	 */
	/*! 
	 * The calculation is implemented by calling the corresponding
	 * LOCA::DerivUtils::computeDwtCeDx() method of the passed 
	 * LOCA::DerivUtils object.
	 */
	virtual NOX::Abstract::Group::ReturnType 
	computeDwtCeDx(const NOX::Abstract::Vector& w1,
		       const NOX::Abstract::Vector& w2,
		       const NOX::Abstract::Vector& y,
		       const NOX::Abstract::Vector& z,
		       double omega,
		       NOX::Abstract::Vector& result_real,
		       NOX::Abstract::Vector& result_imag);

	//! Bring NOX::Abstract::Group::operator=() into scope
	using NOX::Abstract::Group::operator=;
  
      }; // class FiniteDifferenceGroup
    } // namespace MinimallyAugmented
  } // namespace Hopf
} // namespace LOCA

#endif
