//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source: /space/CVS/Trilinos/packages/nox/test/epetra/DS6.5.1/DennisSchnabel.H,v $
//  $Author: rhoope $
//  $Date: 2007/06/21 16:23:01 $
//  $Revision: 1.6 $
// ************************************************************************
//@HEADER
                                                                                
// Finite Element Problem Class
/* Provides function (RHS) and Jacobian evaluations for the  
 * 2 equation test for quadratic and cubic line searches 
 * from Dennis & Schnabel's book, chp 6. example 6.5.1
 *  
 *    U0**2 + U1**2 - 2 = 0
 *    exp(U0-1) + U1**3 -2 = 0
 */

#ifndef _NOX_EXAMPLE_DENNIS_SCHNABEL_651_H
#define _NOX_EXAMPLE_DENNIS_SCHNABEL_651_H

#include "NOX_Epetra_Interface_Required.H"
#include "Teuchos_RCP.hpp"

// Forward Declarations
class Epetra_Comm;
class Epetra_Map; 
class Epetra_Vector;
class Epetra_Import;
class Epetra_CrsGraph;
class Epetra_CrsMatrix;

// Flag to tell the evaluate routine what objects to fill
enum FillType {F_ONLY, MATRIX_ONLY, ALL}; 

// Finite Element Problem Class
class DennisSchnabel { 

public:

  // Constructor
  DennisSchnabel(int NumGlobalElements, Epetra_Comm& Comm);

  // Destructor
  ~DennisSchnabel();

  // Evaluates the function (RHS) and/or the Jacobian using the solution 
  // values in solnVector.
  bool evaluate( NOX::Epetra::Interface::Required::FillType fillType,
                 const Epetra_Vector *solnVector, Epetra_Vector *rhsVector);

  // Return a reference to the Epetra_Vector with the initial guess
  // that is generated by this class.
  Teuchos::RCP<Epetra_Vector> getSolution();
  
  // Return a reference to the Epetra_Vector with the Jacobian
  // that is generated by this class.
  Teuchos::RCP<Epetra_CrsMatrix> getJacobian();

private:

  // inserts the global column indices into the Graph
  Epetra_CrsGraph& generateGraph(Epetra_CrsGraph& AA);

private:

  FillType flag;
  Epetra_Map* StandardMap; 
  Epetra_Map* OverlapMap;
  Epetra_Import* Importer;
  Teuchos::RCP<Epetra_Vector> initialSolution;
  Epetra_Vector* soln;
  Epetra_Vector* rhs;
  Epetra_CrsGraph* AA;
  Teuchos::RCP<Epetra_CrsMatrix> A;
  Epetra_Comm* Comm;

  int MyPID;              // Process number
  int NumProc;            // Total number of processes
  int NumMyElements;      // Number of elements owned by this process
  int NumGlobalElements;  // Total Number of elements

};
#endif




