//@HEADER
// ************************************************************************
// 
//            NOX: An Object-Oriented Nonlinear Solver Package
//                 Copyright (2002) Sandia Corporation
// 
//            LOCA: Library of Continuation Algorithms Package
//                 Copyright (2005) Sandia Corporation
// 
// Under terms of Contract DE-AC04-94AL85000, there is a non-exclusive
// license for use of this work by or on behalf of the U.S. Government.
// 
// This library is free software; you can redistribute it and/or modify
// it under the terms of the GNU Lesser General Public License as
// published by the Free Software Foundation; either version 2.1 of the
// License, or (at your option) any later version.
//  
// This library is distributed in the hope that it will be useful, but
// WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
// 
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
// USA
// 
// Questions? Contact Roger Pawlowski (rppawlo@sandia.gov) or 
// Eric Phipps (etphipp@sandia.gov), Sandia National Laboratories.
// ************************************************************************
//  CVS Information
//  $Source: /space/CVS/Trilinos/packages/nox/test/epetra/MultiPhysics/NOX_Epetra_SchurInterface.H,v $
//  $Author: rhoope $
//  $Date: 2007/06/21 16:23:09 $
//  $Revision: 1.2 $
// ************************************************************************
//@HEADER
                                                                                
#ifndef NOX_EPETRA_SCHURINTERFACE_H
#define NOX_EPETRA_SCHURINTERFACE_H

#include "NOX_Epetra.H"

//-----------------------------------------------------------------------------

// This is a new class that may eventually get moved into NOX::Epetra.  For now,
// this is simply used as a testbed for driving new coupling algorithms - RWH 10/23/2006

namespace NOX {

namespace Epetra {

class SchurInterface
{
public:

  SchurInterface() { };

  virtual ~SchurInterface() { };

  //! Apply the action of a matrix block on a vector
  virtual bool applyBlockAction( int rowBlock, int colBlock, const Epetra_Vector & x, Epetra_Vector & result ) = 0;

  //! Apply the action of a matrix block inverse on a vector
  virtual bool applyBlockInverseAction( int rowBlock, int colBlock, const Epetra_Vector & x, Epetra_Vector & result ) = 0;

  //! Get the communicator
  virtual const Epetra_Comm & getComm() = 0; 

  //! Query availability of explicit operator
  virtual bool hasExplicitOperator( int rowBlock, int colBlock )
    { return false; }

  //! Access explicit operator
  virtual Teuchos::RCP<Epetra_Operator> getExplicitOperator( int rowBlock, int colBlock )
    { return Teuchos::null; }

};
} // Epetra
} // NOX

#endif
