package games.strategy.grid.delegate;

import java.util.Collection;
import java.util.HashSet;
import java.util.List;

import games.strategy.common.delegate.BaseEditDelegate;
import games.strategy.engine.data.ChangeFactory;
import games.strategy.engine.data.GameData;
import games.strategy.engine.data.PlayerID;
import games.strategy.engine.data.Territory;
import games.strategy.engine.data.Unit;
import games.strategy.engine.message.IRemote;
import games.strategy.grid.delegate.remote.IGridEditDelegate;
import games.strategy.triplea.attatchments.TerritoryAttachment;
import games.strategy.triplea.delegate.Matches;
import games.strategy.triplea.formatter.MyFormatter;
import games.strategy.util.Match;

public class EditDelegate extends BaseEditDelegate implements IGridEditDelegate {
  @Override
  public String removeUnits(final Territory territory, final Collection<Unit> units) {
    String result = null;
    if (null != (result = checkEditMode())) {
      return result;
    }
    if (null != (result = validateRemoveUnits(getData(), territory, units))) {
      return result;
    }
    if (units == null || units.isEmpty()) {
      return null;
    }
    final Collection<PlayerID> owners = new HashSet<PlayerID>();
    for (final Unit u : units) {
      owners.add(u.getOwner());
    }
    for (final PlayerID p : owners) {
      final List<Unit> unitsOwned = Match.getMatches(units, Matches.unitIsOwnedBy(p));
      logEvent("Removing units owned by " + p.getName() + " from " + territory.getName() + ": "
          + MyFormatter.unitsToTextNoOwner(unitsOwned), unitsOwned);
      m_bridge.addChange(ChangeFactory.removeUnits(territory, unitsOwned));
    }
    return null;
  }

  public static String validateRemoveUnits(final GameData data, final Territory territory,
      final Collection<Unit> units) {
    final String result = null;
    if (units.isEmpty()) {
      return "No units selected";
    }
    /*
     * all units should be same owner
     * final PlayerID player = units.iterator().next().getOwner();
     * if (!Match.allMatch(units, Matches.unitIsOwnedBy(player)))
     * return "Not all units have the same owner";
     */
    return result;
  }

  @Override
  public String addUnits(final Territory territory, final Collection<Unit> units) {
    String result = null;
    if (null != (result = checkEditMode())) {
      return result;
    }
    if (null != (result = validateAddUnits(getData(), territory, units))) {
      return result;
    }
    if (units == null || units.isEmpty()) {
      return null;
    }
    logEvent("Adding units owned by " + units.iterator().next().getOwner().getName() + " to " + territory.getName()
        + ": " + MyFormatter.unitsToTextNoOwner(units), units);
    m_bridge.addChange(ChangeFactory.addUnits(territory, units));
    return null;
  }

  public static String validateAddUnits(final GameData data, final Territory territory, final Collection<Unit> units) {
    final String result = null;
    if (units.isEmpty()) {
      return "No units selected";
    }
    if (territory.getUnits().getUnitCount() > 0) {
      return "Territory already contains units";
    }
    return result;
  }

  @Override
  public String changeTerritoryOwner(final Territory territory, final PlayerID player) {
    String result = null;
    if (null != (result = checkEditMode())) {
      return result;
    }
    if (null != (result = validateChangeTerritoryOwner(getData(), territory, player))) {
      return result;
    }
    if (territory == null) {
      return null;
    }
    logEvent("Changing ownership of " + territory.getName() + " from " + territory.getOwner().getName() + " to "
        + player.getName(), territory);
    m_bridge.addChange(ChangeFactory.changeOwner(territory, player));
    return null;
  }

  public static String validateChangeTerritoryOwner(final GameData data, final Territory territory,
      final PlayerID player) {
    final String result = null;
    final TerritoryAttachment ta = TerritoryAttachment.get(territory, true);
    if (ta == null) {
      return "Territory has no attachment";
    }
    return result;
  }

  @Override
  public Class<? extends IRemote> getRemoteType() {
    return IGridEditDelegate.class;
  }
}
