/*
 * class EnvAST (derived from InfoAST, but not intended to
 * be a node of a syntax tree of a TTCN-3 document!):
 *
 * A data structure describing environments of identifiers and
 * types which belong to the same scope. EnvASTs are NOT nodes 
 * of the AST, they are some sort of parallel data structure
 * which may nevertheless be referenced from inside an AST.
 *
 * This data structure stores the symbol table in a tree
 * resembling the nested scope structure of an TTNC-3 document.
 * Since we use ANTLRs facilities to maintain this data structure, 
 * we can easily traverse such a symbol table tree by e.g. using 
 * ANTLRs tree parsing mechanisms.
 *
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include <cstdarg>
#include "EnvAST.hpp"

ANTLR_BEGIN_NAMESPACE(antlr)

EnvAST::EnvAST()
{
}


EnvAST::EnvAST( RefToken t ) : InfoAST( t )
{
}

void  EnvAST::setParentEnv( RefEnvAST p ) {
  parentEnv = p;
}

RefEnvAST  EnvAST::getParentEnv () const {
  return parentEnv;
}


// Add AST nodes to Env node (using a variable number of parameters): 
// length specifies number of AST nodes which are passed, 
// factory is used for copying the AST nodes into the Env tree.
void  EnvAST::addASTList (int count, ASTFactory *factory, ...) {
  va_list  ap; // "handle" for dealing with variable number of parameters
  va_start(ap,factory); // we are interested in parameters following the "factory" parameter
  for (int i = 0; i < count; i++) {
    RefAST  ast = *(va_arg(ap,RefAST*)); // get next parameter
    if (ast.get() && ast != antlr::nullAST) {
      addChild(factory->dupTree(ast)); // insert AST node passed as parameter into own node
    }
  }
  va_end(ap); // end of variable number of parameter processing
}


// Add AST nodes to an Env node (using a variable number of parameters): 
// ast specifies the Env node, 
// length specifies number of AST nodes which are passed, 
// factory is used for copying the AST nodes into the Env tree

void  EnvAST::addASTList (RefAST ast, int count, ASTFactory *factory, ...) {
  va_list  ap; // "handle" for dealing with variable number of parameters
  va_start(ap,factory); // we are interested in parameters following the "factory" parameter
  for (int i = 0; i < count; i++) {
    RefAST  ast2 = *(va_arg(ap,RefAST*)); // get next parameter
    if (ast2.get() && ast2 != antlr::nullAST) {
      ast->addChild(factory->dupTree(ast2)); // insert AST node passed as parameter into node ast
    }
  }
  va_end(ap);
}

// required for ANTLRs factory design pattern
RefAST  EnvAST::factory()
{
  return RefAST( new EnvAST );
}


ANTLR_END_NAMESPACE
