/*
 * class ScopeAST (derived from InfoAST):
 * An AST node class describing TTCN-3 scopes by using EnvAST nodes.
 *
 * ScopeASTs are inserted into the AST instead of ordinary InfoASTs
 * whenever an AST node relates to a TTCN-3 statement which starts
 * a new scope.
 * In this case, a ScopeAST is used just like an ordinary InfoAST node,
 * but additionally provides a reference to an environment data structure. 
 * (Such an environment data structure stores type information of identifiers 
 * declared in a scope. The environment data structure is independent from 
 * ANTLRs AST. But due to our lazyness we use ANTLRs facilities to maintain
 * this data structure, hence we use ANTLRs AST nodes also as data structure
 * for environments. Nevertheless, those EnvAST nodes do not represent a
 * syntax tree, but a collection of identifiers and types.)
 *
 * Copyright (C) 2001 Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *
 *    Institute for Telematics,
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 */

#include "ScopeAST.hpp"

ANTLR_BEGIN_NAMESPACE(antlr)

// ANTLR_USE_NAMESPACE(std)map< RefString, RefString > InfoAST::_filenames;


RefEnvAST  ScopeAST::getEnv() const
{
  return environment;
}


ScopeAST::ScopeAST() : InfoAST(), environment(RefEnvAST(new EnvAST))
{
}


ScopeAST::ScopeAST( RefToken t ) : InfoAST( t ), environment(RefEnvAST(new EnvAST))
{
}


ScopeAST::ScopeAST( RefEnvAST env ) : InfoAST(), environment(env)
{
}


/*
RefAST  ScopeAST::factory()
{
  return RefAST( new InfoAST );
}
*/

ANTLR_END_NAMESPACE
