/*
 *     SymbolParser for TTCN-3
 *
 * Copyright (C) 2002 Institute for Telematics
 *
 *    Michael Schmitt <schmitt@itm.mu-luebeck.de>
 *    Roman Koch <rkoch@itm.mu-luebeck.de>
 *    Helmut Neukirchen <neukirchen@itm.mu-luebeck.de>
 *
 *    Medical University of Luebeck,
 *    Ratzeburger Allee 160,
 *    23538 Luebeck,
 *    Germany
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * $Id: TTCNSymbolParser.g,v 1.3 2003/08/10 13:26:57 debacle Exp $
 *
 * This file is intended to be used with ANTLR 2.7.1 or higher. ANTLR is a parser generator that
 * is based on 'linear approximate' lookahead analysis (a kind of weak LL(k) analysis).
 * ANTLR is free software provided by jGuru.com (MageLang Institute). For further information
 * please refer to http://www.antlr.org. My special thanks go to Terence Parr from jGuru.com.
 *
 * If you make use of this TTCN-3 grammar specification, please send a little email in which
 * you tell us what you are using it for and whether you consider it useful. Any grammar
 * corrections and extensions (e.g. for semantics checks and abstract syntax tree transformation)
 * are welcome. For the latest release of all TTCN-3 grammar files please have a look at
 * http://www.itm.mu-luebeck.de/english/research/specification/ttcn3parser. We also invite you to
 * visit the WWW pages of the Institute for Telematics at http://www.itm.mu-luebeck.de.
 *
 *
 * This grammar is based on the BNF Syntax Rev. 12.2 (October 2001) 
 *
 */

header "pre_include_hpp"
{
  #include <string>

  using std::string;

  // $Id: TTCNSymbolParser.g,v 1.3 2003/08/10 13:26:57 debacle Exp $
}


header "post_include_cpp"
{
  #include "InfoAST.hpp"
  #include "ScopeAST.hpp"
  #include "EnvAST.hpp"

   static string   ttcnTreeParserVersion = "$Id: TTCNSymbolParser.g,v 1.3 2003/08/10 13:26:57 debacle Exp $";
}


options
{
  language  = "Cpp";
  namespace = "TTCNGrammar";
  namespaceStd = "std";
  namespaceAntlr = "antlr";
  genHashLines = true;
}


class TTCNSymbolParser extends TreeParser;


options
{
  k = 1;
  importVocab = TTCNParser;
  defaultErrorHandler = true;
  buildAST = false;
}


startStatement[ string id ] returns[ bool r ] :

  (  { r = true; }
     varInstance { if (true) return r; }
   | . )*

;


ttcn3Document :

  #( TTCN3Document
     ( ttcn3Module )+ )

;


/*****  SECTION A.1.6.1 - TTCN Module *****/

ttcn3Module :

  #( TTCN3Module
     ttcn3ModuleId ( moduleParList )? )

;


ttcn3ModuleId :

  #( TTCN3ModuleId
     /*module*/ Identifier ( definitiveIdentifier )? )

;


definitiveIdentifier :

  #( DefinitiveIdentifier
     ( definitiveObjIdComponent )+ )

;


definitiveObjIdComponent :

    nameForm
  | definitiveNumberForm
  | definitiveNameAndNumberForm

;


definitiveNumberForm :

  Number

;


definitiveNameAndNumberForm :

  #( DefinitiveNameAndNumberForm
     Identifier definitiveNumberForm )

;


moduleParList :

  #( ModuleParList
     ( modulePar )+ )

;


modulePar :

  #( ModulePar
     /*modulePar*/ type /*modulePar*/ Identifier )

;


/*****  SECTION A.1.6.2.1 - Typedef Definitions *****/

recordDef :

  #( RecordDef
     structDefBody )

;


structDefBody :   // no root node needed

  (   /*structType*/ Identifier ( structDefFormalParList )?
    | Address )
  ( structFieldDef )*

;


structDefFormalParList :

  #( StructDefFormalParList
     ( structDefFormalPar )+ )

;


structDefFormalPar :

    formalValuePar
  | formalTypePar

;


structFieldDef :

  #( StructFieldDef
     type /*structField*/ Identifier ( arrayDef )? ( subTypeSpec )? ( Optional )? )

;


unionDef :

  #( UnionDef
     (   /*structType*/ Identifier ( structDefFormalParList )?
       | Address )
     ( unionFieldDef )+ )

;


unionFieldDef :

  #( UnionFieldDef
     type /*structField*/ Identifier ( arrayDef )? ( subTypeSpec )? )

;


setDef :

  #( SetDef
     structDefBody )

;


recordOfDef :

  #( RecordOfDef
     ( stringLength )? structOfDefBody )

;


structOfDefBody :   // no root node needed

  type
  (   /*structType*/ Identifier
    | Address )
  ( subTypeSpec )?

;


setOfDef :

  #( SetOfDef
     ( stringLength )? structOfDefBody )

;


enumDef :

  #( EnumDef
     (   /*enumType*/ Identifier
       | Address )
     ( namedValue )+ )

;


namedValue :

  #( NamedValue
     /*namedValue*/ Identifier ( Number )? )

;


subTypeDef :

  #( SubTypeDef
     type
     (   /*subType*/ Identifier
       | Address )
     ( arrayDef )? ( subTypeSpec )? )

;


subTypeSpec :

    allowedValues
  | stringLength

;


allowedValues :

  #( AllowedValues
     ( valueOrRange )+ )

;


valueOrRange :

    integerRangeDef
  | singleConstExpression

;


integerRangeDef :

  #( IntegerRangeDef
     lowerBound upperBound )

;


stringLength :

  #( StringLength
     singleConstExpression ( upperBound )? )

;


portType :

  #( PortType
     ( ( globalModuleId Identifier ) => globalModuleId )? /*portType*/ Identifier )

;


portDef :

  #( PortDef
     /*portType*/ Identifier portDefAttribs )

;


portDefAttribs :

    messageAttribs
  | procedureAttribs
  | mixedAttribs

;


messageAttribs :

  #( MessageAttribs
     ( messageList )+ )

;


messageList :

  #( MessageList
     direction ( All | ( type )+ ) )

;


direction :

    In
  | Out
  | InOut

;


procedureAttribs :

  #( ProcedureAttribs
     ( procedureList )+ )

;


procedureList :

  #( ProcedureList
     direction ( All | ( signature )+ ) )

;


mixedAttribs :

  #( MixedAttribs
     ( mixedList )+ )

;


mixedList :

  #( MixedList
     direction ( All | ( procOrType )+ ) )

;


procOrType :

    ( type ) =>
    type
  | signature

;


componentDef :

  #( ComponentDef
     /*componentType*/ Identifier ( componentElementDef )* )

;


componentType :

  #( ComponentType
     ( ( globalModuleId Identifier ) => globalModuleId )? /*componentType*/ Identifier )

;


componentElementDef :

    portInstance
  | varInstance
  | timerInstance
  | constDef

;


portInstance :

  #( PortInstance
     portType ( portElement )+ )

;


portElement :

  #( PortElement
     /*port*/ Identifier ( arrayDef )? )

;


/*****  SECTION A.1.6.2.2 - Constant Definitions  *****/

constDef :

  #( ConstDef
     type ( singleConstDef )+ )

;


singleConstDef :

  #( SingleConstDef
     /*const*/ Identifier ( arrayDef )? )

;


/*****  SECTION A.1.6.2.3 - Template Definitions  *****/

templateDef :

  #( TemplateDef
     baseTemplate ( derivedDef )? )

;


baseTemplate :

  #( BaseTemplate
     ( ( type ) => type | signature ) /*template*/ Identifier ( templateFormalParList )? )

;


derivedDef :

  #( DerivedDef
     (   ( ( globalModuleId Identifier ) => globalModuleId )? /*template*/ Identifier
       | /*templatePar*/ Identifier ) )

;


templateFormalParList :

  #( TemplateFormalParList
     ( templateFormalPar )+ )

;


templateFormalPar :

    formalValuePar
  | formalTemplatePar

;


arrayOrBitRef :

  #( ArrayOrBitRef
     singleExpression )

;


lowerBound :

    singleConstExpression
  | MinusInfinity

;


upperBound :

    singleConstExpression
  | Infinity

;


/*****  SECTION A.1.6.2.4 - Function Definitions  *****/

functionDef :

  #( FunctionDef
     /*function*/ Identifier ( functionFormalParList )? ( runsOnSpec )? ( returnType )? )

;


functionFormalParList :

  #( FunctionFormalParList
     ( functionFormalPar )+ )

;


functionFormalPar :

    formalValuePar
  | formalTimerPar
  | formalTemplatePar
  | formalPortPar

;


returnType :

  #( ReturnType
     type )

;


runsOnSpec :

  #( RunsOnSpec
     componentType  )

;


/*****  SECTION A.1.6.2.5 - Signature Definitions  *****/

signatureDef :

  #( SignatureDef
     /*signature*/ Identifier ( signatureFormalParList )? ( returnType | Noblock )? ( exceptionSpec )? )

;


signatureFormalParList :

  #( SignatureFormalParList
     ( signatureFormalPar )+ )

;


signatureFormalPar :

  formalValuePar

;


exceptionSpec :

  #( ExceptionSpec
     ( type )+ )

;


signature :

  ( ( globalModuleId Identifier ) => globalModuleId )? /*signature*/ Identifier

;


/*****  SECTION A.1.6.2.6 - Testcase Definitions  *****/

testcaseDef :

  #( TestcaseDef
     /*testcase*/ Identifier ( testcaseFormalParList )? configSpec )

;


testcaseFormalParList :

  #( TestcaseFormalParList
     ( testcaseFormalPar )+ )

;


testcaseFormalPar :

    formalValuePar
  | formalTemplatePar

;


configSpec :

  #( ConfigSpec
     runsOnSpec ( systemSpec )? )

;


systemSpec :

  #( SystemSpec
     componentType )

;


/*****  SECTION A.1.6.2.7 - Teststep Definitions  *****/

teststepDef :

  #( TeststepDef
     /*teststep*/ Identifier ( teststepFormalParList )? ( runsOnSpec )? )

;


teststepFormalParList :

  functionFormalParList

;


/*****  SECTION A.1.6.2.8 - Import Definitions  *****/


importFromSpec :

  #( ImportFromSpec
     moduleId ( Nonrecursive )? )

;


moduleId :

  #( ModuleId
     globalModuleId ( extModuleActualParList )? ( languageSpec )? )

;


languageSpec :

  #( LanguageSpec
     freeText )

;


globalModuleId :

  /*module*/ Identifier ( objectIdentifierValue )?

;


extModuleActualParList :

  #( ExtModuleActualParList
     (   ( parExpressionSpec )+
       | ( notUsedOrModuleParExpression )+ ) )

;


parExpressionSpec :

  #( ParExpressionSpec
     /*extModulePar*/ Identifier /*modulePar*/ expression )

;


notUsedOrModuleParExpression :

    /*modulePar*/ expression
  | NotUsed

;


importGroupSpec :

  #( ImportGroupSpec
     ( ( fullGroupIdentifier )+  
     | All 
     )
   )

;


fullGroupIdentifier :

  /* group */ Identifier ( /* group */ Identifier )* 
;


importTypeDefSpec :

  #( ImportTypeDefSpec
     ( ( typeDefIdentifier )+ 
     | All
     )
   )

;


typeDefIdentifier :

  /*structType,enumType,portType,componentType,subType*/ Identifier

;


importTemplateSpec :

  #( ImportTemplateSpec
     ( ( /*template*/ Identifier )+ 
     | All
     )
   )

;


importConstSpec :

  #( ImportConstSpec
     ( (/*const*/ Identifier )+ 
     | All
     )
   )

;


importTeststepSpec :

  #( ImportTeststepSpec
     ( ( /*teststep*/ Identifier )+ 
     | All
     )
   )

;


importTestcaseSpec :

  #( ImportTestcaseSpec
     ( ( /*testcase*/ Identifier )+ 
     | All
     )
   )

;


importFunctionSpec :

  #( ImportFunctionSpec
     ( ( /*function*/ Identifier )+  
     | All
     )
   )

;


importSignatureSpec :

  #( ImportSignatureSpec
     ( (/*signature*/ Identifier )+  
     | All
     )
   )

;


/*****  SECTION A.1.6.2.9 - Group Definitions  *****/

groupDef :

  #( GroupDef
     /*group*/ Identifier )

;


/*****  SECTION A.1.6.2.10 - External Function Definitions  *****/

extFunctionDef :

  #( ExtFunctionDef
     /*extFunction*/ Identifier ( functionFormalParList )? ( returnType )? )

;

/*****  SECTION A.1.6.2.11 - External Constant Definitions  *****/

extConstDef :

  #( ExtConstDef
     type /*extConst*/ Identifier )

;


/*****  SECTION A.1.6.3.1 - Variable Instantiation  *****/

varInstance :

  #( VarInstance
     type ( singleVarInstance )+ )

;


singleVarInstance :

  #( SingleVarInstance
     /*var*/ Identifier ( arrayDef )? )

;


/*****  SECTION A.1.6.3.2 - Timer Instantiation  *****/


timerInstance :
  #( TimerInstance
            ( singleTimerInstance )+ )

;


singleTimerInstance :
  #( SingleTimerInstance
     /*timer*/ Identifier ( arrayDef )? )

;


/*****  SECTION A.1.6.4 - Type  *****/

type :

    predefinedType
  | referencedType

;


predefinedType :

    TypeBitstring
  | TypeBoolean
  | TypeCharstring
  | TypeUniversalCharstring
  | TypeChar
  | TypeUniversalChar
  | TypeInteger
  | TypeOctetstring
  | TypeObjId
  | TypeHexstring
  | TypeVerdictType
  | TypeFloat
  | TypeAddress
  | TypeDefault
  | TypeAnyType
;


referencedType :

  ( ( globalModuleId typeReference ) =>
    globalModuleId )?
  typeReference ( extendedFieldReference )?

;


typeReference :

    /*structType*/ Identifier ( typeActualParList )?
  | /*enumType,subType,typePar,componentType*/ Identifier

;


typeActualParList :

  #( TypeActualParList
     ( typeActualPar )+ )

;


typeActualPar :

    singleConstExpression
  | type

;


/*****  SECTION A.1.6.4.1 - Array Types *****/

arrayDef :

  #( ArrayDefList
     ( arrayDef2 )+ )

;


arrayDef2 :

  #( ArrayDef
     arrayBounds ( arrayBounds )? )

;


arrayBounds :

  singleConstExpression

;


/*****  SECTION A.1.6.5 - Value  *****/

objectIdentifierValue :

  #( ObjectIdentifierValue
     ( objIdComponent )+ )

;


objIdComponent :

    nameForm
  | numberForm
  | nameAndNumberForm

;


numberForm :

    Number
  | referencedValue

;


nameAndNumberForm :

  #( NameAndNumberForm
     Identifier numberForm )

;


nameForm :

  Identifier

;


referencedValue :

  valueReference ( extendedFieldReference )?

;


valueReference :

    ( ( globalModuleId Identifier ) => globalModuleId )?
    /*const*/ Identifier
  | /*extConst,valuePar,modulePar,var*/ Identifier

;


freeText :

  CString  // temporary workaround - see TTCNParser.g

;


/*****  SECTION A.1.6.6 - Parameterisation  *****/

formalValuePar :

  #( SomeFormalPar   // -> FormalValuePar
     ( InOut | Out )? type /*valuePar*/ Identifier )

;


formalTypePar :

  #( FormalTypePar
     /*typePar*/ Identifier )

;


formalPortPar :

  #( SomeFormalPar   // -> FormalPortPar
     /*portType*/ Identifier /*portPar*/ Identifier )

;


formalTimerPar :

  #( FormalTimerPar
     /*timerPar*/ Identifier )

;


formalTemplatePar :

  #( FormalTemplatePar
     type /*templatePar*/ Identifier )

;


/*****  SECTION A.1.6.9 - Basic Statements  *****/

expression :

  /* temporarily empty */

;


singleConstExpression :

  singleExpression

;


singleExpression :

  /* temporarily empty */

;


extendedFieldReference :

  (   /*structField*/ Identifier
    | arrayOrBitRef )+

;
