//@TLPGEOLICENCE#

#ifndef _TLP_GEO_ARRAY_H
#define _TLP_GEO_ARRAY_H
#include <cassert>
#include <iostream>

namespace tlp {
  namespace geo {
    /**
     * \brief class for array encapsulation
     *
     * Enables to create an Array of Obj with a
     * Fixed size, limit of the array are checked only
     * in debug mode.
     * 
     * Author : <a href="mailto:auber@tulip-software.org>David Auber</A>
     * Version 0.0.1 24/01/2003 
     */
    template <typename Obj,unsigned int SIZE>
      class Array {
      protected:
      Obj array[SIZE];
      public:
      inline Obj  operator[](const unsigned int i) const;
      inline Obj& operator[](const unsigned int i);
    };
    /**
     * Write array in a stream
     */
    template <typename Obj,unsigned int SIZE>
      std::ostream& operator<<(std::ostream &os,const Array<Obj,SIZE> &);
  }
}

#include "./cxx/Array.cxx"

#endif
