#include <string>
#include <stdio.h>
#include <GL/gl.h>
#include <GL/glut.h>

using namespace std;

typedef struct {
    unsigned long sizeX;
    unsigned long sizeY;
    char *data;
} Image;

struct GlFonts {
  static void drawBitmapString(const char *str);
  static void drawStrokeString(const char *str);
  static void drawTextureString(const char *str);
  static void setBitmapFont(void *font);
  static void setStrokeFont(void *font);
  static void setTextureFont(string);
  static double getStrokeLength(const char *str);
  static void getTextureStringSize(const char *str,unsigned int &w,unsigned int &h);
  private:
  static GLuint	texture;
  static GLuint	base;
  static void *bitmapFont;
  static void *strokeFont;
  static unsigned int getint(FILE *fp);
  static unsigned int getshort(FILE *fp);
  static int imageLoad(char *filename, Image *image);
  static bool load(string);
  static void buildFont();
  static void killFont();
};
