//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <list>
#include <cmath>
#include <typeinfo>
#include <string>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <GL/glut.h>
#include <GL/glu.h>

#include <tulip/LayoutProxy.h>
#include <tulip/MetricProxy.h>
#include <tulip/StringProxy.h>
#include <tulip/SelectionProxy.h>
#include <tulip/SizesProxy.h>
#include <tulip/IntProxy.h>
#include <tulip/ColorsProxy.h>
#include <tulip/SuperGraph.h>
#include <tulip/TemplateFactory.h>

#include "tulip/GlGraph.h"
#include "tulip/Color.h"
#include "tulip/Coord.h"
#include "tulip/Size.h"
#include "tulip/EpsFunction.h"

#include "tulip/Glyph.h"

using namespace std;


//test 
#include <sys/timeb.h>

TemplateFactory<GlyphFactory,Glyph,GlyphContext *> GlGraph::glyphFactory;

//====================================================
//dummy constructor made private since we want to forbid calling copy constructor
GlGraph::GlGraph(const GlGraph &) {}

GlGraph::GlGraph(GlGraphStrategy &strategy):
  strategy(&strategy),
  _superGraph(0),
  graphProperties(0),
  backgroundColor(65,65,65),
  _viewArrow(false), _viewLabel(false),
  _viewKey(false), _viewStrahler(false),
  _viewAutoScale(true),  _incrementalRendering(true),_edgeColorInterpolate(true), _edge3D(false),
  _viewOrtho(true), _FontsType(0),
  winH(480), winW(640),
  elementColor(0), elementSize(0),elementShape(0),elementSelected(0),elementLabel(0),
  elementLayout(0),elementMetaGraph(0), elementTexture(NULL),
  selectBuf(0), objectGraph(0),
  objectCube(0), objectCone(0),
  sceneTranslation(0,0,0),
  sceneRotation(Coord(180,0,0)),
  winX(0), winY(0),
  maxNumberOfNodeToDraw(500),maxNumberOfEdgeToDraw(500)
{
  TRACE_EXEC();
  // cerr << "GlGraph constructor" << endl;

  // this will load a default glyphTable
  // later setGlyphTable can be called to set a particular order of glyphs,
  // then completed by missing glyphs in this new table
  GlyphTableGlyph v;
  this->setGlyphTable(v);
  for (int i=0;i<500000;++i) bitmapMask[i]=100;
  //  cerr << "GlGraph constructor Ok" << endl;
}

GlGraph::GlGraph(GlGraphStrategy &strategy, const GlGraph &g) :
  strategy(&strategy),
  _superGraph(g._superGraph),
  backgroundColor(g.backgroundColor),
  _viewArrow(g._viewArrow), _viewLabel(g._viewLabel),
  _viewKey(g._viewKey), _viewStrahler(g._viewStrahler),
  _viewAutoScale(g._viewAutoScale), _incrementalRendering(g._incrementalRendering),
  _edgeColorInterpolate(g._edgeColorInterpolate), _edge3D(g._edge3D),
  _viewOrtho(g._viewOrtho), _FontsType(g._FontsType),
  winH(g.winH), winW(g.winW),
  //texturesMap not initialized... dunno if we should, and how
  metaGraphDL(g.metaGraphDL),
  selectBuf(NULL),
  objectGraph(g.objectGraph), objectCube(g.objectCube), objectCone(g.objectCone),
  sceneTranslation(g.sceneTranslation),
  sceneRotation(g.sceneRotation),
  cameraEyes(g.cameraEyes), cameraCenter(g.cameraCenter), cameraUp(g.cameraUp),
  cameraZoomFactor(g.cameraZoomFactor),
  distCam(g.distCam),
  winX(g.winX), winY(g.winY),
  colorMap(g.colorMap), colorMapMin(g.colorMapMin), colorMapMax(g.colorMapMax),
  nodeSizex(g.nodeSizex), nodeSizey(g.nodeSizey),
  maxNumberOfNodeToDraw(g.maxNumberOfNodeToDraw),
  maxNumberOfEdgeToDraw(g.maxNumberOfEdgeToDraw)
{
  graphProperties = (_superGraph == NULL) ? NULL : _superGraph->getPropertyProxyContainer();
  setGlyphTable(g.getGlyphTable());
  initProxies();
  for (int i=0; i<4; ++i) vp[i] = g.vp[i];
  if (isViewStrahler()) {
    buildOrderedList();
  }
  for (int i=0;i<500000;++i) bitmapMask[i]=100;
}
//====================================================
GlGraph::~GlGraph() {
  for (unsigned int i=0;i<glyphTable.size();i++)
    delete glyphTable[i];
}

//==================================================
void GlGraph::init() {
  TRACE_EXEC();
  goodScale();
  sceneRotation.set(180,0,0);
  //  sceneTranslation.set(0,0,0);

}
//====================================================
void GlGraph::initializeGL() {
  TRACE_EXEC();
  initGlParameter();
  updateList();
}
//==================================================
void GlGraph::resizeGL( int w, int h ) {
  TRACE_EXEC();
  strategy->MakeCurrent();
  winH=h;
  winW=w;
  glViewport(winX,winY,winW,winH);
  glGetIntegerv(GL_VIEWPORT, vp);
  strategy->toUpdate=true;
}
//====================================================
void GlGraph::paintGL() {
  TRACE_EXEC();
  if (!_incrementalRendering) {
    occlusionTest.reset();
    while (strategy->timerIsActive()) drawGraph();
    initProjection(); 
    initModelView();
    initGlParameter();
    Iterator<edge> *drawEdgesIt=_superGraph->getEdges();
    Iterator<node> *drawNodesIt=_superGraph->getNodes();
    if (isViewKey()) 
      drawFanNodes(_superGraph->numberOfNodes(),drawNodesIt);
    else {
      drawEdges(_superGraph->numberOfEdges(),drawEdgesIt);
      drawNodes(_superGraph->numberOfNodes(),drawNodesIt);
    }
    delete drawEdgesIt;
    delete drawNodesIt;
    glFlush();
  }
  else {
    if (strategy->toUpdate || (!strategy->timerIsActive())) {
	occlusionTest.reset();
	strategy->toUpdate=false;
	strategy->timerStop();
	//================================
	//Initialize the incremental rendering and start to draw
	{
	  initProjection();
	  initModelView();
	  initGlParameter();
	  if (elementLayout!=NULL) {
	    if (isViewStrahler()) {
	      drawNodesIteratorStl=orderedNode.begin();
	      drawEdgesIteratorStl=orderedEdge.begin();
	      drawNodesIterator= new stlListIterator<node>(drawNodesIteratorStl,orderedNode.end());
	      drawEdgesIterator= new stlListIterator<edge>(drawEdgesIteratorStl,orderedEdge.end());
	    }
	    else {
	      drawNodesIterator=_superGraph->getNodes();
	      drawEdgesIterator=_superGraph->getEdges();
	    }
	    strategy->timerStop();
	    strategy->timerStart(0);
	    drawGraph();
	  }
	}
      }
    strategy->mPaint(this);
  }
}
//====================================================
SuperGraph* GlGraph::getSuperGraph() const {return _superGraph;}
//====================================================
//Il faut vrifier les observer pour ne pas observer un truc qui change.
void GlGraph::setSuperGraph(SuperGraph *superGraph) {
  TRACE_EXEC();
  assert(superGraph != NULL);
  strategy->timerStop();
  _superGraph=superGraph;
  graphProperties=superGraph->getPropertyProxyContainer();
  initProxies();
  if (isViewStrahler()) {
    buildOrderedList();
  }
}
//==================================================
void GlGraph::redraw() {
  TRACE_EXEC();
  strategy->toUpdate=true;
  strategy->timerStop();
  strategy->UpdateGL();
  //  cerr << "GlGraph::update end" << endl;
}
//====================================================
void GlGraph::goodScale() {
  TRACE_EXEC();
  double dx=elementSize->getMax(_superGraph)[0]+elementLayout->getMax(_superGraph)[0]-elementLayout->getMin(_superGraph)[0];
  double dy=elementSize->getMax(_superGraph)[1]+elementLayout->getMax(_superGraph)[1]-elementLayout->getMin(_superGraph)[1];
  double dz=elementSize->getMax(_superGraph)[2]+elementLayout->getMax(_superGraph)[2]-elementLayout->getMin(_superGraph)[2];

  sceneTranslation[0]=- (elementLayout->getMax(_superGraph)[0]+elementLayout->getMin(_superGraph)[0])/2.0;
  sceneTranslation[1]=- (elementLayout->getMax(_superGraph)[1]+elementLayout->getMin(_superGraph)[1])/2.0;
  sceneTranslation[2]=- (elementLayout->getMax(_superGraph)[2]+elementLayout->getMin(_superGraph)[2])/2.0;

  if ((dx==0) && (dy==0) && (dz==0)) {
    dx=dy=dz=10;
  }

  //maxDist is the radius of sphere hull of the layout bounding box
  distCam=sqrt(dx*dx+dy*dy+dz*dz)/2;
  
  cameraEyes.set(0,0,-distCam);
  cameraCenter.set(0,0,0);
  cameraUp.set(0,1,0);
  if (_viewOrtho) 
    cameraZoomFactor=0.5;
  else 
    cameraZoomFactor=0.5;

  //  cout << "distCam=" << distCam << " zoomFactor=" << cameraZoomFactor<< endl;
    
 //  cerr << "GlGraph::goodScale Ok" << endl;
}
//====================================================
void GlGraph::drawGraph() {
  TRACE_EXEC();
  strategy->MakeCurrent();
  bool finished=false;
  unsigned int numberOfDrawnNodes=0;
  unsigned int numberOfDrawnEdges=0;
  int startTimeNode,endTimeNode;
  int startTimeEdge,endTimeEdge;
  if (isViewKey()) {
    if (drawNodesIterator->hasNext())	{
      startTimeNode=glutGet(GLUT_ELAPSED_TIME);
      numberOfDrawnNodes=drawFanNodes(maxNumberOfNodeToDraw,drawNodesIterator);
      endTimeNode=glutGet(GLUT_ELAPSED_TIME);
    } 
    else  
      finished=true;
  }
  else {
    if (drawEdgesIterator->hasNext()) {
      startTimeEdge=glutGet(GLUT_ELAPSED_TIME);
      numberOfDrawnEdges=drawEdges(maxNumberOfEdgeToDraw, drawEdgesIterator);
      endTimeEdge=glutGet(GLUT_ELAPSED_TIME);
    }
    if (!drawEdgesIterator->hasNext()) {
      if (drawNodesIterator->hasNext())	{
	startTimeNode=glutGet(GLUT_ELAPSED_TIME);
	numberOfDrawnNodes=drawNodes(maxNumberOfNodeToDraw, drawNodesIterator);
	endTimeNode=glutGet(GLUT_ELAPSED_TIME);
      }
      else  {
	finished=true;
      }
    }
  }
  unsigned int t1;
  if (numberOfDrawnEdges>=10) {
    t1=endTimeEdge-startTimeEdge; //time spent in millisecond to draw edges
    if (t1!=0) 
      maxNumberOfEdgeToDraw=(maxNumberOfEdgeToDraw+3*(int)((50.0*(double)numberOfDrawnEdges)/(double)t1))/4;
  }
  if (numberOfDrawnNodes>=10) {
    t1=endTimeNode-startTimeNode;//time spent in millisecond to draw nodes
    if (t1!=0) 
      maxNumberOfNodeToDraw=(maxNumberOfNodeToDraw+3*(int)((50.0*(double)numberOfDrawnNodes)/(double)t1))/4;
  }
  if (maxNumberOfEdgeToDraw<=10) maxNumberOfEdgeToDraw=10;
  if (maxNumberOfNodeToDraw<=10) maxNumberOfNodeToDraw=10;
  strategy->UpdateGL();
  if (finished)  strategy->timerStop();
}
//====================================================
void GlGraph::outputEPS(int size, int doSort, const char *filename) {
  TRACE_EXEC();
  strategy->MakeCurrent();
  GLfloat *feedbackBuffer;
  GLint returned;
  FILE *file;
  //backup unsuported rendering setting
  bool labelsTmp=_viewLabel;
  setViewLabel(false);
  feedbackBuffer = (GLfloat *)calloc(size, sizeof(GLfloat));
  glFeedbackBuffer(size, GL_3D_COLOR, feedbackBuffer);
  glRenderMode(GL_FEEDBACK);
  initProjection();
  initModelView();
  initGlParameter();
  Iterator<node> *drawNodesIterator=_superGraph->getNodes();
  drawNodes(_superGraph->numberOfNodes(), drawNodesIterator);  
  delete drawNodesIterator;
  Iterator<edge> *drawEdgesIterator=_superGraph->getEdges();
  drawEdges(_superGraph->numberOfEdges(), drawEdgesIterator);  
  delete drawEdgesIterator;
  returned = glRenderMode(GL_RENDER);
  if (filename) {
    file = fopen(filename, "w");
    if (file) 
      {spewWireFrameEPS(file, doSort, returned, feedbackBuffer, "rendereps");} 
    else 
      {printf("Could not open %s\n", filename);}
  } 
  else 
    {printBuffer(returned, feedbackBuffer);}
  free(feedbackBuffer);
  if (labelsTmp) setViewLabel(true);
}
//====================================================
unsigned char * GlGraph::getImage(int &w, int &h) {
  TRACE_EXEC();
  strategy->MakeCurrent();
  _incrementalRendering=false;
  strategy->UpdateGL();
  _incrementalRendering=true;

  w=winW;h=winH;
  unsigned char *image=(unsigned char *)malloc(w*h*3*sizeof(unsigned char));
  glPixelStorei(GL_PACK_ALIGNMENT,1);
  glReadPixels(0,0,winW,winH,GL_RGB,GL_UNSIGNED_BYTE,image);
#ifndef DNDEBUG
  cerr << "GlGraph::getImage end" << endl;
#endif
  return image;
}
//====================================================
// Composition de rotations, homotheties et translations transformant les
// coordonnees x, y, et z.
void GlGraph::changeCoord(double& x,double& y,double& z) {
  TRACE_EXEC();
  strategy->MakeCurrent();
  double X=x,Y=y;//,Z=z;
  double xScr,yScr,zScr;
  GLint realy;
  GLint viewport[4];
  GLdouble modelview[16], projection[16];
  glGetIntegerv (GL_VIEWPORT, viewport);
  glGetDoublev (GL_MODELVIEW_MATRIX, modelview);
  glGetDoublev (GL_PROJECTION_MATRIX, projection);
  realy = viewport[3] - (GLint) Y - 1;
  gluProject(0,0,0,modelview,projection,viewport,&xScr,&yScr,&zScr);
  gluUnProject((GLdouble)winW- X, (GLdouble) realy, zScr, modelview, projection, viewport, &x, &y, &z);
}
//====================================================
class LessThanNode {
public:
  MetricProxy *metric;
  bool operator() (node n1,node n2)
  {return (metric->getNodeValue(n1) > metric->getNodeValue(n2));} 
};
//====================================================
class LessThanEdge{
public:
  MetricProxy *metric;
  SuperGraph *sp;
  bool operator() (edge e1,edge e2)
  {return (metric->getNodeValue(sp->target(e1))>metric->getNodeValue(sp->target(e2)));} 
};
//====================================================
//function for building the ordered list of nodes and edges
void GlGraph::buildOrderedList()
{
  TRACE_EXEC();
  orderedNode.clear();
  if (!isViewStrahler()) return;
  bool cached,resultBool;string erreurMsg;
  MetricProxy *metric=getLocalProxy<MetricProxy>(_superGraph,"StrahlerGeneral",cached,resultBool,erreurMsg);
  Iterator<node> *itN=_superGraph->getNodes();
  for (;itN->hasNext();) 
    orderedNode.push_back(itN->next());
  delete itN;
  LessThanNode comp;
  comp.metric=metric;
  orderedNode.sort(comp);
  orderedEdge.clear();
  Iterator<edge> *itE=_superGraph->getEdges();
  for (;itE->hasNext();) orderedEdge.push_back(itE->next());
  delete itE;
  LessThanEdge comp2;
  comp2.metric=metric;
  comp2.sp=_superGraph;
  orderedEdge.sort(comp2);
}



/*
//static void RGBtoHSV( int r, int g, int b, int *h, int *s, int *v );
//static void HSVtoRGB( int h, int s, int v, int *r, int *g, int *b );
// Color space conversion functions
void RGBtoHSV( int r, int g, int b, int *h, int *s, int *v )
{
  int min, max, delta;

  // "<?" and ">?" are GNU G++ extensions; may not work with other compiler
  min = r <? g <? b;
  max = r >? g >? b;
  *v = max;				// v

  delta = max - min;

  if( max != 0 )
    *s = delta / max;		// s
  else {
    // r = g = b = 0		// s = 0, v is undefined
    *s = 0;
    *h = -1;
    return;
  }

  if( r == max )
    *h = ( g - b ) / delta;		// between yellow & magenta
  else if( g == max )
    *h = 2 + ( b - r ) / delta;	// between cyan & yellow
  else
    *h = 4 + ( r - g ) / delta;	// between magenta & cyan

  *h *= 60;				// degrees
  if( *h < 0 )
    *h += 360;
}

void HSVtoRGB( int h, int s, int v, int *r, int *g, int *b )
{
  int i;
  int f, p, q, t;

  if( s == 0 ) {
    // achromatic (grey)
    *r = *g = *b = v;
    return;
  }

  h /= 60;			// sector 0 to 5
  i = (int) floor((float)h);
  f = h - i;			// factorial part of h
  p = v * ( 255 - s );
  q = v * ( 255 - s * f );
  t = v * ( 255 - s * ( 255 - f ) );

  switch( i ) {
  case 0:
    *r = v;
    *g = t;
    *b = p;
    break;
  case 1:
    *r = q;
    *g = v;
    *b = p;
    break;
  case 2:
    *r = p;
    *g = v;
    *b = t;
    break;
  case 3:
    *r = p;
    *g = q;
    *b = v;
    break;
  case 4:
    *r = t;
    *g = p;
    *b = v;
    break;
  default:		// case 5:
    *r = v;
    *g = p;
    *b = q;
    break;
  }
}
*/

/*
  //Old code to build Color map no more Use but ... Should be use to help the user.
  if (finished)
  {
  glDisable(GL_LIGHTING);
  glDisable(GL_CULL_FACE);
  //Display the color Index in the left corner of the screen if in metric mode
  if (isViewKey() && (getViewColorEntry()!=0))
  {
  glMatrixMode(GL_PROJECTION);
  glPushMatrix();
  glLoadIdentity();
  glOrtho(-winW/2, winW/2, -winH/2, winH/2, 0.0, 1.0);
  glMatrixMode(GL_MODELVIEW);
  glPushMatrix();
  glLoadIdentity();
  map<double,double>::iterator itCol;
  double nbEle=colorMap.size();
  double pos=1;
  double ratio;
  const double sizeX=20;
  const double sizeY=60;

  Color tmpCol;
  Color startCol;
  Color tmpCol2;
  Color startCol2;

  for (itCol=colorMap.begin();itCol!=colorMap.end();++itCol)
  {
  ratio=((*itCol).second - colorMapMin) / (colorMapMax - colorMapMin );
  int h,s,v;
  int r=nodeBaseColor.getR(), g=nodeBaseColor.getG(), b=nodeBaseColor.getB();
  RGBtoHSV(r,g,b,&h,&s,&v);
  h = (int)(h*ratio); s=(int)(s/2+s*ratio/2); v=(int)(v/2+v*ratio/2);
  HSVtoRGB(h,s,v,&r,&g,&b);
  tmpCol.set(r,g,b);
  glBegin(GL_QUADS);
  SetColor(tmpCol);
  glVertex2f(5-winW/2, ((sizeY/nbEle)*pos)+(winH/2.0-sizeY-5.0));
  SetColor(tmpCol);
  glVertex2f(sizeX+5-winW/2, ((sizeY/nbEle)*pos)+(winH/2.0-sizeY-5.0) );
  SetColor(startCol);
  glVertex2f(sizeX+5-winW/2, ((sizeY/nbEle)*(pos-1))+(winH/2.0-sizeY-5.0) );
  SetColor(startCol);
  glVertex2f(5-winW/2, ((sizeY/nbEle)*(pos-1.0))+(winH/2.0-sizeY-5.0));
  glEnd();

  r=edgeBaseColor.getR(), g=edgeBaseColor.getG(), b=edgeBaseColor.getB();
  RGBtoHSV(r,g,b,&h,&s,&v);
  h = (int)(h*ratio); s=(int)(s/2+s*ratio/2); v=(int)(v/2+v*ratio/2);
  HSVtoRGB(h,s,v,&r,&g,&b);
  tmpCol2.set(r,g,b);
  glBegin(GL_QUADS);
  SetColor(tmpCol2);
  glVertex2f(6-winW/2+sizeX, ((sizeY/nbEle)*pos)+(winH/2.0-sizeY-5.0));
  SetColor(tmpCol2);
  glVertex2f(sizeX+6-winW/2+sizeX, ((sizeY/nbEle)*pos)+(winH/2.0-sizeY-5.0) );
  SetColor(startCol2);
  glVertex2f(sizeX+6-winW/2+sizeX, ((sizeY/nbEle)*(pos-1))+(winH/2.0-sizeY-5.0) );
  SetColor(startCol2);
  glVertex2f(6-winW/2+sizeX, ((sizeY/nbEle)*(pos-1.0))+(winH/2.0-sizeY-5.0));
  glEnd();
  pos++;
  startCol2=tmpCol2;
  startCol=tmpCol;
  }
  glPopMatrix();
  glMatrixMode(GL_PROJECTION);
  glPopMatrix();
  glMatrixMode(GL_MODELVIEW);
  glEnable(GL_CULL_FACE);
  glEnable(GL_LIGHTING);
  }
  }
*/
