#ifndef CLUSTERTREE_H
#define CLUSTERTREE_H
#include <qpoint.h>
#include "ClusterTreeData.h"

class SuperGraph;
class SubGraph;
class QListViewItem;
class QListView;
class QPopupMenu;
class Cluster;

class ClusterTree : public ClusterTreeData
{ 
  Q_OBJECT;
  
public:
  ClusterTree(SuperGraph *rootGraph, QWidget* parent = 0, const char* name = 0, WFlags fl = 0);
  ClusterTree(QWidget* parent = 0, const char *name = 0, WFlags fl = 0);
  ~ClusterTree();
  SuperGraph *getSuperGraph() const;
  QPopupMenu *getContextMenu() const;
  
public slots:
  void update();
  void contextRemoveCluster();
  void contextRemoveAllCluster();
  void contextCloneSubgraphCluster();
  void contextMoveUpCluster();
  void contextRenameCluster();
  void contextCloneCluster();
  void setSuperGraph(const SuperGraph *);
  void setRootSuperGraph(SuperGraph *);
  void currentSuperGraphChanged(const SuperGraph *);
  void rightButtonClusterTree(QListViewItem *item, const QPoint &p, int c);
  void showHidePartition(QListViewItem *item,const QPoint &p, int i);
  void showHidePartition(QListViewItem *item);
  void setContextMenu(QPopupMenu *);
  
signals:
  void aboutToRemoveView(SuperGraph *);
  void aboutToRemoveAllView(SuperGraph *);
  void supergraphChanged(SuperGraph *);
  
public:
    //fields
    SuperGraph *_currentSuperGraph, *_rootSuperGraph;
    Cluster *_clusterTree;
    SubGraph *_currentSubGraph;
    
protected:
  void buildTreeView(QListView *item,SubGraph *p);
  void buildTreeView(QListViewItem *item,SubGraph *p);

private:
  bool removeOperation;
  QPopupMenu *contextMenu;

};
#endif // CLUSTERTREE_H
