//-*-c++-*-
#ifndef MOUSEZOOMBOX_H
#define MOUSEZOOMBOX_H

#include <tulip/MouseInterface.h>

class SuperGraph;
class QMouseEvent;
class QKeyEvent;

class MouseZoomBox : public MouseInterface
{
private:
  unsigned int x, y;
  int w, h;
  bool started;
  SuperGraph *superGraph;

public:
  MouseZoomBox();
  ~MouseZoomBox();
  void mPressEvent(GlGraphWidget *,QMouseEvent *);
  void mReleaseEvent(GlGraphWidget *,QMouseEvent *);
  void mMoveEvent(GlGraphWidget *,QMouseEvent *);
  void mPaint(GlGraphWidget *);
  void keyPressEvent (GlGraphWidget *, QKeyEvent *) {}
  void keyReleaseEvent(GlGraphWidget *, QKeyEvent *);
  void wheelEvent(GlGraphWidget *, QWheelEvent *) {}

private:
  void cancelZoomOp(GlGraphWidget *);
};

#endif //MOUSEZOOMBOX_H
