//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/
#ifndef _CLUSTERTULIP_H
#define _CLUSTERTULIP_H

#include <list>
#include <map>
#include "SubGraph.h"
#include "Observable.h"


/**
 */
class Cluster:public Observable
{
private : 
  ///
  std::list<SubGraph *> lSubGraph;
  ///
  SubGraph *rootSubGraph;

public:
  ///
  Cluster();
  ///
  ~Cluster();
  ///
  int id;
  ///Move the sub graph at the same place as it father
  void moveUp(SubGraph *p);
  ///Delete recursively all the children of the SubGraph
  void recEraseChildren(SubGraph *,SubGraph *);
  ///Delete the subgraph and all its subGraph recursively
  void recErase(SubGraph *);
  ///Delete the subGraph and reconnect its children to their grand father;
  void erase(SubGraph *);
  /**
    Return a new SubGrap attached to a SuperGraph and which 
    is the child of the subGraph in parameter, The Selection gived in 
    paramexter is use to build the new superGraph. If the SelectionProxy
    contains nodes or edges which are not in the superGraph attached
    to the subGraph their are automatically ignored.
  */
  SubGraph  *createSubGraph(const std::string& ,SubGraph *,SelectionProxy *);
  ///Return the root subGraph.
  SubGraph  *getRootSubGraph();
};

#endif







