//-*-c++-*-
#ifndef _CLUSTERING_H
#define _CLUSTERING_H

#include <list>
#include <string>
#include "SuperGraph.h"
#include "MethodFactory.h"
#include "WithParameter.h"
///Interface for clustering plug-ins
class Clustering : public WithParameter
{ 
public :
  ///
  Clustering (ClusterContext context):superGraph(context.superGraph),pluginProgress(context.pluginProgress),dataSet(context.dataSet){}
  ///
  virtual ~Clustering() {}
  ///
  virtual bool run() = 0;
  ///
  virtual bool check(std::string &) = 0;
  ///
  virtual void reset() = 0;  

protected:
  ///
  SuperGraph *superGraph;
  ///
  PluginProgress *pluginProgress;
  ///
  DataSet *dataSet;
};

#endif






