//-*-c++-*-
#ifndef TULIP_METRICPROXY_H
#define TULIP_METRICPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;

///
class MetricProxy:public PropertyProxy<DoubleType,DoubleType>
{ 
  ///
  friend class Metric;

public:
  static TemplateFactory<MetricFactory,Metric,PropertyContext *> factory;

private:
  ///
  STL_EXT_NS::hash_map<int ,double> maxN,minN,maxE,minE;
  ///
  STL_EXT_NS::hash_map<int,bool> minMaxOkNode;
  STL_EXT_NS::hash_map<int,bool> minMaxOkEdge;
  ///
  void computeMinMaxNode(SuperGraph *sg=0);
  void computeMinMaxEdge(SuperGraph *sg=0);
  ///
  Metric *currentMetric;

public :
  ///
  MetricProxy (PropertyContext *context);
  ///
  ~MetricProxy();
  ///
  bool select(std::string , std::string &);
  ///
  DoubleType::RealType  getNodeMin(SuperGraph *sg=0);
  ///
  DoubleType::RealType  getNodeMax(SuperGraph *sg=0);
  ///
  DoubleType::RealType  getEdgeMin(SuperGraph *sg=0);
  ///
  DoubleType::RealType  getEdgeMax(SuperGraph *sg=0);
  ///
  virtual void setNodeValue_handler(const node n);
  virtual void setEdgeValue_handler(const edge e);
  virtual void setAllNodeValue_handler();
  virtual void setAllEdgeValue_handler();
  ///
  void reset_handler();
  ///
  void recompute_handler();
  ///
  void clone_handler(PropertyProxy<DoubleType,DoubleType> &);
};

#endif
