//-*-c++-*-
#ifndef TULIP_SIZESPROXY_H
#define TULIP_SIZESPROXY_H

#include "PropertyProxy.h"
#include "MethodFactory.h"
#include "TemplateFactory.h"

class PropertyContext;

///
class SizesProxy:public PropertyProxy<SizeType,SizeType>
{ 
  ///
  friend class Sizes;

public:
  static TemplateFactory<SizesFactory,Sizes,PropertyContext *> factory;

private:
  ///
  Sizes *currentSizes;
  //  Coord max,min;
  STL_EXT_NS::hash_map<int,Size> max,min;
  ///
  STL_EXT_NS::hash_map<int,bool> minMaxOk;
  ///
  void computeMinMax(SuperGraph * sg=NULL);
public :
  ///
  SizesProxy (PropertyContext *context);
  ///
  ~SizesProxy();
  ///
  bool select(std::string , std::string &);
  ///
  void reset_handler();
  ///
  void recompute_handler();
  ///
  Size getMax(SuperGraph *sg=0);
  Size getMin(SuperGraph *sg=0);
protected:
  void resetMinMax();
  virtual void setNodeValue_handler(const node n);
  virtual void setEdgeValue_handler(const edge e);
  virtual void setAllNodeValue_handler();
  virtual void setAllEdgeValue_handler();

};

#endif

