//-*-c++-*-
#ifndef _SUBGRAPH_H
#define _SUBGRAPH_H

#include <list>
#include <map>
#include <string>

class SelectionProxy;
class SuperGraph;

///
class SubGraph
{
friend class Cluster;

public:
  /**
     Return the name of the SubGraph
  */
  std::string getName();
  /**
     Return the father of the subGraph
     if it has no father it return itself.
  */
  SubGraph *getFather();
  /**
     Return a pointer to the list
     of children of this subGraph.
  */
  std::list<SubGraph *> *getSubGraphChildren();
  /**
     Return a pointer on the selectionProxy
     used to filter the superGraph. Warning
     using this  function implies to know
     exactly the structure of the library.
  */
  SelectionProxy *getSubGraphProxy() const;
  /**
     Set the associated view of this SubGraph.
   */
  void setAssociatedSuperGraph(SuperGraph *sg);
  /**
     Return the assoiciated SuperGraph of this
     subGraph
  */
  SuperGraph *getAssociatedSuperGraph();
  /**
     Constructor
  */
  SubGraph();
  /**
     Destructor
  */
  ~SubGraph();
  /**
     Set the selecetion proxy used to build the
     subGraph
  */
  void setSubGraphProxy(SelectionProxy *);
  /**
     set the fahter of the subGraph
  */
  void setFather(SubGraph *);
  /**
     Set the name of the subGraph
  */
  void setName(std::string );
  /**
     add a child to the subGraph
  */
  void addSubGraphChild(SubGraph *);
  /**
     remove a child to the subGraph
  */
  void subSubGraphChild(SubGraph *);


public :
  SuperGraph   *associatedGraph;
  SelectionProxy   *subGraphProxy;
  std::list<SubGraph *> subGraphChildList;
  std::list<SubGraph *> fusionChildList;
  std::list<SubGraph *> fusionFatherList;
  SubGraph *father;
  std::string name;
};

#endif
