//-*-c++-*-
#ifndef TULIP_SUPERGRAPHABSTRACT_H
#define TULIP_SUPERGRAPHABSTRACT_H

#include "SuperGraph.h"
#include "Reflect.h"

class SelectionProxy;

///Abstract class for default graph operations.
class SuperGraphAbstract:public SuperGraph
{
public:
  SuperGraphAbstract();
  virtual ~SuperGraphAbstract();
  //=======================================
  ///
  virtual int deg(const node) const;
  ///
  virtual int indeg(const node) const;
  ///
  virtual int outdeg(const node) const;
  ///
  virtual node source(const edge) const;
  ///
  virtual node target(const edge) const;
  ///
  virtual node opposite(const edge, const node)const;
  ///
  virtual void reverse(const edge);
  //=======================================
  ///
  virtual node getInNode(const node,unsigned int )const;
  ///
  virtual node getOutNode(const node,unsigned int )const;
  ///
  virtual bool isTree();
  ///
  virtual bool isAcyclic();
  ///
  virtual int numberOfNodes() const;
  ///
  virtual int numberOfEdges() const;
  ///
  DataSet & getAttributes() {return attributes;}
private:
  bool acyclicTest(node n,SelectionProxy *,SelectionProxy *);
  DataSet attributes;

};

#endif
