//-*-c++-*-
#ifndef _TEMPLATEFACTORY_H
#define _TEMPLATEFACTORY_H

#include "PluginLoader.h"
#include "WithParameter.h"

template<class ObjectFactory, class ObjectType, class Parameter> class TemplateFactory
{
public:
  typedef void *(*func)();
  typedef std::map< std::string , ObjectFactory * , std::less<std::string> > ObjectCreator;
  
  void *handle;
  func createObj;
  ObjectCreator objMap;
  std::map<std::string,StructDef> objParam;

  bool exists(const std::string &pluginName);
  void load(std::string pluginPath,std::string type,PluginLoader *loader=0);
  bool load(std::string file);
  ObjectType *getObject(std::string name,Parameter p);
  StructDef getParam(std::string name);
};

#include "./cxx/TemplateFactory.cxx"
#endif































