//-*-c++-*
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 26/09/2001
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

//====================================================================================
template<class Proxytype>
Proxytype* getLocalProxy(SuperGraph *supergraph,const std::string &st,bool &cached ,bool &resultBool ,std::string &resultStr,PluginProgress *plugProgress,DataSet *dataSet=0)
{
  PropertyProxyContainer *proxyContainer=supergraph->getPropertyProxyContainer();
  if (proxyContainer->existLocalProxy(st)) {
    cached=true;
    PProxy* tmpProxy=proxyContainer->getLocalProxy(st);
    assert ( typeid((*tmpProxy)) == typeid(Proxytype) );
    return ( (Proxytype *)(tmpProxy) );
  }
  else {
    PropertyContext context;
    PluginProgress *tmpProgress;
    if (plugProgress==0) tmpProgress=new PluginProgressDefault();
    else tmpProgress=plugProgress;
    context.pluginProgress=tmpProgress;
    context.superGraph=proxyContainer->superGraph;
    context.dataSet=dataSet;
    proxyContainer->setLocalProxy(st,new Proxytype(&context));
    cached=false;
    resultBool=((Proxytype *)proxyContainer->getLocalProxy(st))->select(st,resultStr);
    if (plugProgress==0) delete tmpProgress;
  }
  return ((Proxytype *)proxyContainer->getLocalProxy(st));
}
//====================================================================================
template<class Proxytype>
Proxytype* getLocalProxy(SuperGraph *supergraph,const std::string &st)
{
  PropertyProxyContainer *proxyContainer=supergraph->getPropertyProxyContainer();
  Proxytype *tmp;
  if (proxyContainer->existLocalProxy(st)) {
    PProxy* tmpProxy=proxyContainer->getLocalProxy(st);
    assert ( typeid((*tmpProxy)) == typeid(Proxytype) );
    return ( (Proxytype *)(tmpProxy) );
  }
  else  {
    PropertyContext context;
    context.superGraph=proxyContainer->superGraph;
    proxyContainer->setLocalProxy(st,tmp=new Proxytype(&context));
  }
  return (tmp);
}
//====================================================================================
template<class Proxytype>
Proxytype* getProxy(SuperGraph *supergraph,const std::string &st,bool &cached,bool &resultBool ,std::string &resultStr,PluginProgress *plugProgress,DataSet *dataSet=0)
{
  PropertyProxyContainer *proxyContainer=supergraph->getPropertyProxyContainer();
  if (proxyContainer->existProxy(st)) {
    cached=true;
    PProxy* tmpProxy=proxyContainer->getProxy(st);
    assert ( typeid((*tmpProxy)) == typeid(Proxytype) );
    return ( (Proxytype *)(tmpProxy) );
  }
  else {
    PropertyContext context;
    PluginProgress *tmpProgress;
    if (plugProgress==0) tmpProgress=new PluginProgressDefault();
    else tmpProgress=plugProgress;
    context.pluginProgress=tmpProgress;
    context.superGraph=proxyContainer->superGraph;
    context.dataSet=dataSet;
    proxyContainer->setLocalProxy(st,new Proxytype(&context));
    cached=false;
    resultBool=((Proxytype *)proxyContainer->getProxy(st))->select(st,resultStr);
    if (plugProgress==0) delete tmpProgress;
  }
  return (((Proxytype *)proxyContainer->getLocalProxy(st)));
}
//====================================================================================
template<class Proxytype>
Proxytype* getProxy(SuperGraph *supergraph,const std::string &st)
{
  PropertyProxyContainer *proxyContainer=supergraph->getPropertyProxyContainer();
  Proxytype *tmp;
  if (proxyContainer->existProxy(st)) {
    PProxy* tmpProxy=proxyContainer->getProxy(st);
    assert ( typeid((*tmpProxy)) == typeid(Proxytype) );
    return ( (Proxytype *)(tmpProxy) );
  }
  else {
    PropertyContext context;
    context.superGraph=proxyContainer->superGraph;
    proxyContainer->setLocalProxy(st,tmp=new Proxytype(&context));
  }
  return (tmp);
}
//====================================================================================
