//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/ColorsProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Colors.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

TemplateFactory<ColorsFactory,Colors,PropertyContext *> ColorsProxy::factory;
//==============================
ColorsProxy::ColorsProxy (PropertyContext *context):PropertyProxy<ColorType,ColorType>(context)
{
  currentColors=NULL;
  propertyProxy=this;
}
//==============================
ColorsProxy::~ColorsProxy() 
{
}    
//====================================================================
///Fonction permettnet de changer la Colors:public Property du ColorsProxy
bool ColorsProxy::select(string s,string &s2)
{
  Observable::holdObservers();
  context.propertyProxy=this;
  Colors *tmpColors=factory.getObject(s,&context);
  bool   result;
  if (tmpColors!=NULL)
    {
      result=tmpColors->check(s2);
      if (currentColors!=NULL) delete currentColors;
      currentColors=tmpColors;
      changeCurrentProperty(currentColors,s);
      if (result)
	{
	  reset();
	  currentColors->run();
	}
    }
  else
    {
      s2="Data colors enable";
      result=true;
    }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}
//=============================================================================
void ColorsProxy::reset_handler()
{
}
//=============================================================================
void ColorsProxy::recompute_handler()
{
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
}








