//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cmath>
#include "tulip/LayoutProxy.h"
#include "tulip/TemplateFactory.h"
#include "tulip/Coord.h"
#include "tulip/MethodFactory.h"
#include "tulip/Metric.h"
#include "tulip/PluginContext.h"

using namespace std;

inline double sqr(double x){return (x*x);}

TemplateFactory<LayoutFactory,Layout,PropertyContext *> LayoutProxy::factory;

LayoutProxy::LayoutProxy (PropertyContext *context):PropertyProxy<PointType,LineType>(context) {
  minMaxOk[(int)superGraph]=false;
  currentLayout=0;
  propertyProxy=this;
}

LayoutProxy::~LayoutProxy() {}

///Be careful, the layoutProperty can't be recursive.
bool LayoutProxy::computeOtherLayout(string s,string &s2) {
#ifndef NDEBUG
  cerr << "LayoutProxy::computeOtherLayout(string,string&)" << endl;
#endif
  Observable::holdObservers();
  context.superGraph=superGraph;
  context.propertyProxy=this;
  Layout *tmpLayout=factory.getObject(s,&context);
  bool   result=true;
  if (tmpLayout!=NULL) {
    reset();
    result=tmpLayout->check(s2);
    if (result) {
      tmpLayout->run();
    }
    else {
      s2="PropertyProxy::computeOtherLayout check false :" + s + "Error:" + s2;
      result=false;
    }
    delete tmpLayout;
  }
  else {
    s2="PropertyProxy::computeOtherLayout no layout found";
    result=true;
  }
  Observable::unholdObservers();
  return result;
}

bool LayoutProxy::select(string s,string &s2) {
#ifndef NDEBUG
  cerr << "LayoutProxy::select(string,string&)" << endl;
#endif
  Observable::holdObservers();
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
  context.propertyProxy=this;
  Layout *tmpLayout=factory.getObject(s,&context);

  bool result;
  if (tmpLayout!=NULL) {
    result=tmpLayout->check(s2);
    if(currentLayout!=NULL) delete currentLayout;
    currentLayout=tmpLayout;
    changeCurrentProperty(currentLayout,s);
    if (result) {
      reset();
      currentLayout->run();
      center();
    }
  }
  else {
    s2="Data layout enable";
    result=true;
  }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}

Coord LayoutProxy::getMax(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;

  if (!minMaxOk[sgi]) computeMinMax(sg);
  return max[sgi];
}

Coord  LayoutProxy::getMin(SuperGraph *sg) {
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOk.find(sgi)==minMaxOk.end()) minMaxOk[sgi]=false;
  if (!minMaxOk[sgi]) computeMinMax(sg);
  return min[sgi];
}

//=================================================================================
void LayoutProxy::center() {
#ifndef NDEBUG
  cerr << "LayoutProxy::center()" << endl;
#endif
  int sgi=(int)superGraph;
  if (superGraph->numberOfNodes()==0) return;
  Observable::holdObservers();
  Coord translate=getMax()+getMin();
  translate/=2;
  Coord tmpCoord;
  
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmpCoord=getNodeValue(itn);
    tmpCoord-=translate;
    setNodeValue(itn,tmpCoord);
  } delete itN;

  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    if (!getEdgeValue(ite).empty()) {
      LineType::RealType::iterator itCoord;
      itCoord=getEdgeValue(ite).begin();
      while(itCoord!=getEdgeValue(ite).end()) {
	*itCoord-=translate;
	++itCoord;
      }
    }
  } delete itE;
  
  STL_EXT_NS::hash_map<int,bool>::iterator it;
  for (it=minMaxOk.begin();it!=minMaxOk.end();++it) {
    min[it->first]-=translate;
    max[it->first]-=translate;
  }
  notifyObservers();
  Observable::unholdObservers();
}
//=================================================================================
void LayoutProxy::normalize() {
#ifndef NDEBUG
  cerr << "normalize is deprecated" << endl;
#endif
  
  if (superGraph->numberOfNodes()==0) return;
  Observable::holdObservers();
  double dtmp,dtmpMax=1;
  Coord tmpCoord;
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();)  {
      node itn=itN->next();
      tmpCoord=getNodeValue(itn);
      dtmp=sqr(tmpCoord.getX())+sqr(tmpCoord.getY())+sqr(tmpCoord.getZ());
      if (dtmp>dtmpMax) dtmpMax=dtmp;
    }
  delete itN;

  dtmpMax=sqrt(dtmpMax);
  dtmpMax=512.0/dtmpMax;

  itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmpCoord=getNodeValue(itn);
    tmpCoord.setX(tmpCoord.getX()*dtmpMax);
    tmpCoord.setY(tmpCoord.getY()*dtmpMax);
    tmpCoord.setZ(tmpCoord.getZ()*dtmpMax);
    setNodeValue(itn,tmpCoord);
  } delete itN;

  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    LineType::RealType::iterator itCoord;
    itCoord=getEdgeValue(ite).begin();
    while(itCoord!=getEdgeValue(ite).end()) {
      *itCoord=dtmpMax;
      ++itCoord;
    }
  }delete itE;

  STL_EXT_NS::hash_map<int,bool>::iterator it;
  for (it=minMaxOk.begin();it!=minMaxOk.end();++it) {
    min[it->first]*=dtmpMax;
    max[it->first]*=dtmpMax;
  }
  notifyObservers();
  Observable::unholdObservers();
}
//=================================================================================
void LayoutProxy::perfectAspectRatio() {
#ifndef NDEBUG
  cerr << __PRETTY_FUNCTION__ << endl;
#endif
  if (superGraph->numberOfNodes()==0) return;
  Observable::holdObservers();

  double scaleX,scaleY,scaleZ;
  double deltaX,deltaY,deltaZ;

  deltaX = (double )getMax()[0]-(double )getMin()[0];
  deltaY = (double )getMax()[1]-(double )getMin()[1];
  deltaZ = (double )getMax()[2]-(double )getMin()[2];

  double delta= deltaX >? deltaY;
  delta = delta >? deltaZ;

  if (delta<0.001) return;

  if (deltaX<0.001) deltaX=delta;
  if (deltaY<0.001) deltaY=delta;
  if (deltaZ<0.001) deltaZ=delta;
  scaleX = delta / deltaX;
  scaleY = delta / deltaY;
  scaleZ = delta / deltaZ;

  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    Coord tmpCoord=getNodeValue(itn);
    tmpCoord.setX((double )tmpCoord.getX()*scaleX);
    tmpCoord.setY((double )tmpCoord.getY()*scaleY);
    tmpCoord.setZ((double )tmpCoord.getZ()*scaleZ);
    setNodeValue(itn,tmpCoord);
  }delete itN;

  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    LineType::RealType::iterator itCoord;
    itCoord=getEdgeValue(ite).begin();
    while(itCoord!=getEdgeValue(ite).end()) {
      Coord tmpCoord=*itCoord;
      tmpCoord.setX((double )tmpCoord.getX()*scaleX);
      tmpCoord.setY((double )tmpCoord.getY()*scaleY);
      tmpCoord.setZ((double )tmpCoord.getZ()*scaleZ);
      *itCoord=tmpCoord;
      ++itCoord;
    }
  }delete itE;

  notifyObservers();
  Observable::unholdObservers();
}
//=================================================================================
void LayoutProxy::computeMinMax(SuperGraph *sg) {
#ifndef NDEBUG
  cerr << "LayoutProxy::computeMinMax begin" << endl;
#endif

  Coord tmpCoord;
  double maxX=0;
  double minX=0;
  double maxY=0;
  double minY=0;
  double maxZ=0;
  double minZ=0;
  if (sg==0) sg=superGraph;

  Iterator<node> *itN=sg->getNodes();
  if  (itN->hasNext()) {
    node itn=itN->next();
    tmpCoord=getNodeValue(itn);
    maxX=tmpCoord.getX();
    minX=tmpCoord.getX();
    maxY=tmpCoord.getY();
    minY=tmpCoord.getY();
    maxZ=tmpCoord.getZ();
    minZ=tmpCoord.getZ();
  }
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmpCoord=getNodeValue(itn);
    if (tmpCoord.getX()>maxX) maxX=tmpCoord.getX();
    if (tmpCoord.getX()<minX) minX=tmpCoord.getX();
    if (tmpCoord.getY()>maxY) maxY=tmpCoord.getY();
    if (tmpCoord.getY()<minY) minY=tmpCoord.getY();
    if (tmpCoord.getZ()>maxZ) maxZ=tmpCoord.getZ();
    if (tmpCoord.getZ()<minZ) minZ=tmpCoord.getZ();
  }delete itN;

  Iterator<edge> *itE=sg->getEdges();
  for (;itE->hasNext();) {
    edge ite=itE->next();
    LineType::RealType::iterator itCoord;
    for (itCoord=getEdgeValue(ite).begin();itCoord!=getEdgeValue(ite).end();++itCoord) {
      tmpCoord=*itCoord;
      if (tmpCoord.getX()>maxX) maxX=tmpCoord.getX();
      if (tmpCoord.getX()<minX) minX=tmpCoord.getX();
      if (tmpCoord.getY()>maxY) maxY=tmpCoord.getY();
      if (tmpCoord.getY()<minY) minY=tmpCoord.getY();
      if (tmpCoord.getZ()>maxZ) maxZ=tmpCoord.getZ();
      if (tmpCoord.getZ()<minZ) minZ=tmpCoord.getZ();
    }
  }delete itE;


  int sgi=(int)sg;

  minMaxOk[sgi]=true;  
  min[sgi].set(minX,minY,minZ);
  max[sgi].set(maxX,maxY,maxZ);
  //  cerr << "LayoutProxy::computeMinMax end" << endl;
}
//=================================================================================
void LayoutProxy::reset_handler() {
  //  cerr << "void LayoutProxy::reset_handler_begin()" << endl;
  resetBoundingBox();
  //    max[it->first]-=translate;
  //  minMaxOk=false;
  //  cerr << "void LayoutProxy::reset_handler_end()" << endl;
}
//=============================================================================
///Poign permettnet le recompute il faut absolument mettre le graphProperties
///currentLayoutProxy  this sinon le rsultat est imprvisible
void LayoutProxy::recompute_handler() {
#ifndef NDEBUG
  cerr << "LayoutProxy::recompute_handler" << endl;
#endif
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
  propertyProxy=this;
}
//=================================================================================
void LayoutProxy::clone_handler(PropertyProxy<PointType,LineType> &proxyC) {
  if (typeid(this)==typeid(&proxyC)) {
    LayoutProxy *proxy=(LayoutProxy *)&proxyC;
    minMaxOk=proxy->minMaxOk;
    min=proxy->min;
      max=proxy->max;
  }
}
//=================================================================================
void LayoutProxy::resetBoundingBox() {
  STL_EXT_NS::hash_map<int,bool>::iterator it;
  for (it=minMaxOk.begin();it!=minMaxOk.end();++it)
    it->second=false;
}
//================================================================================
void LayoutProxy::setNodeValue_handler(const node n){resetBoundingBox();}
void LayoutProxy::setEdgeValue_handler(const edge e){resetBoundingBox();}
void LayoutProxy::setAllNodeValue_handler(){resetBoundingBox();}
void LayoutProxy::setAllEdgeValue_handler(){resetBoundingBox();}








