//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <float.h>
#include "tulip/MetricProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/Metric.h"
#include "tulip/PropertyProxy.h"
#include "tulip/MethodFactory.h"

using namespace std;

TemplateFactory<MetricFactory,Metric,PropertyContext *> MetricProxy::factory;
//==============================
///Constructeur d'un MetricProxy
MetricProxy::MetricProxy (PropertyContext *context):PropertyProxy<DoubleType,DoubleType>(context),
  minMaxOkNode(false),minMaxOkEdge(false),currentMetric(NULL)
{
  propertyProxy=this;
}
//==============================
///Destructeur d'un metric Proxy  
///Vide pour l'instant, cela peut
///provoquer des fuites mmoires
MetricProxy::~MetricProxy() {}    
//====================================================================
///Renvoie le minimum de la mtrique associ aux noeuds du MetricProxy
double MetricProxy::getNodeMin(SuperGraph *sg) 
{
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOkNode.find(sgi)==minMaxOkNode.end()) minMaxOkNode[sgi]=false;
  if (!minMaxOkNode[sgi]) computeMinMaxNode(sg);
  return minN[sgi];

  //  if (!minMaxOkNode) computeMinMaxNode(sg);
  //  return minN;
}
//====================================================================
///Renvoie le maximum de la mtrique associ aux noeuds du MetricProxy
double MetricProxy::getNodeMax(SuperGraph *sg) 
{
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOkNode.find(sgi)==minMaxOkNode.end()) minMaxOkNode[sgi]=false;
  if (!minMaxOkNode[sgi]) computeMinMaxNode(sg);
  return maxN[sgi];

  //if (!minMaxOkNode) computeMinMaxNode(sg);
  //return maxN;
}
//====================================================================
///Renvoie le Minimum de la mtrique associ aux artes du MetricProxy
double MetricProxy::getEdgeMin(SuperGraph *sg) 
{
  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOkEdge.find(sgi)==minMaxOkEdge.end()) minMaxOkEdge[sgi]=false;
  if (!minMaxOkEdge[sgi]) computeMinMaxEdge(sg);
  return minE[sgi];

  //if (!minMaxOkEdge) computeMinMaxEdge(sg);
  //return minE;
}
//====================================================================
///Renvoie le Maximum de la mtrique associ aux artes du MetricProxy
double MetricProxy::getEdgeMax(SuperGraph *sg) 
{

  if (sg==0) sg=superGraph;
  int sgi=(int)sg;
  if (minMaxOkEdge.find(sgi)==minMaxOkEdge.end()) minMaxOkEdge[sgi]=false;
  if (!minMaxOkEdge[sgi]) computeMinMaxEdge(sg);
  return maxE[sgi];
  //  if (!minMaxOkEdge) computeMinMaxEdge(sg);
  //  return maxE;
}
//========================================================================
///Fonction permettnet de changer la Metric:public Property du MetricProxy
bool MetricProxy::select(string s,string &s2) {
  Observable::holdObservers();
  //  context.superGraph=superGraph;
  context.propertyProxy=this;
  Metric *tmpMetric=factory.getObject(s,&context);
  bool   result;
  if (tmpMetric!=NULL) {
    result=tmpMetric->check(s2);
    if (currentMetric!=NULL) delete currentMetric;
    currentMetric=tmpMetric;
    changeCurrentProperty(currentMetric,s);
    if (result)	{
      reset();
      currentMetric->run();
    }
  }
  else {
    s2="Data metric enable";
    result=true;
  }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}
//=========================================================
void MetricProxy::computeMinMaxNode(SuperGraph *sg) {

  double tmp;
  double maxN2,minN2;
  Iterator<node> *itN=superGraph->getNodes();
  if (itN->hasNext()) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    maxN2=tmp;
    minN2=tmp;
  }
  for (;itN->hasNext();) {
    node itn=itN->next();
    tmp=getNodeValue(itn);
    if (tmp>maxN2) maxN2=tmp;
    if (tmp<minN2) minN2=tmp;
  }
  delete itN;

  if (sg==0) sg=superGraph;
  int sgi=(int)sg;

  minMaxOkNode[sgi]=true;  
  minN[sgi]=minN2;
  maxN[sgi]=maxN2;
}
//=========================================================
void MetricProxy::computeMinMaxEdge(SuperGraph *sg) {
  double tmp;
  double maxE2,minE2;
  Iterator<edge> *itE=superGraph->getEdges();
  if (itE->hasNext()) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    maxE2=tmp;
    minE2=tmp;
  }
  for (;itE->hasNext();) {
    edge ite=itE->next();
    tmp=getEdgeValue(ite);
    if (tmp>maxE2) maxE2=tmp;
    if (tmp<minE2) minE2=tmp;
  }
  delete itE;

  if (sg==0) sg=superGraph;
  int sgi=(int)sg;

  minMaxOkEdge[sgi]=true;  
  minE[sgi]=minE2;
  maxE[sgi]=maxE2;
}
//=============================================================================
///Poign permettnet le reset des variables du MetricProxy par le PropertyProxy
void MetricProxy::reset_handler()
{
  minMaxOkNode.clear();
  minMaxOkEdge.clear();
}
//=============================================================================
///Poign permettnet le recompute il faut absolument mettre le graphProperties
///currentMetricProxy  this sinon le rsultat est imprvisible
void MetricProxy::recompute_handler() {
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
  minMaxOkNode.clear();
  minMaxOkEdge.clear();
}
//=================================================================================
void MetricProxy::clone_handler(PropertyProxy<DoubleType,DoubleType> &proxyC) {
  MetricProxy *proxy=(MetricProxy *)&proxyC;
  minMaxOkNode=proxy->minMaxOkNode;
  minMaxOkEdge=proxy->minMaxOkEdge;
  minN=proxy->minN;
  maxN=proxy->maxN;
  minE=proxy->minE;
  maxE=proxy->maxE;
}
//=================================================================================
void MetricProxy::setNodeValue_handler(const node n) {
  minMaxOkNode.clear();
}
void MetricProxy::setEdgeValue_handler(const edge e) {
  minMaxOkEdge.clear();
}
void MetricProxy::setAllNodeValue_handler() {
  minMaxOkNode.clear();
}
void MetricProxy::setAllEdgeValue_handler() {
  minMaxOkEdge.clear();
}








