#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>

#include "tulip/Observable.h"


using namespace std;

int Observable::holdCounter=0;

ObserverMap Observable::holdMap;

void Observable::notifyObservers()
{
  //  cerr << "Observable::notifyObservers" << endl;
  list<Observer*>::iterator itlObs;
  assert(holdCounter>=0);
  if (holdCounter)
    for (itlObs=observersList.begin();itlObs!=observersList.end();++itlObs)
      holdMap[*itlObs].insert(this);
  else
    {
      set<Observable *> tmpSet;
      tmpSet.insert(this);
      for (itlObs=observersList.begin();itlObs!=observersList.end();++itlObs)
	(*itlObs)->update(tmpSet.begin(),tmpSet.end());
    }
}

void Observable::holdObservers()
{
  assert(holdCounter>=0);
  holdCounter++;
}

void Observable::unholdObservers()
{
  holdCounter--;
  assert(holdCounter>=0);
 
  if (holdCounter==0)
    {
      ObserverMap::iterator itMObs;
      for (itMObs=holdMap.begin();itMObs!=holdMap.end();++itMObs)
	itMObs->first->update(itMObs->second.begin(),itMObs->second.end());
      holdMap.clear();
    }
}











