//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/MethodFactory.h"
#include "tulip/StringProxy.h"
#include "tulip/PluginContext.h"
#include "tulip/Observable.h"
#include "tulip/String.h"
#include "tulip/PropertyProxy.h"

using namespace std;


TemplateFactory<StringFactory,String,PropertyContext *> StringProxy::factory;

StringProxy::StringProxy (PropertyContext *context):PropertyProxy<StringType,StringType>(context)
{
  currentString=NULL;
  propertyProxy=this;
}
  
StringProxy::~StringProxy() {}

bool StringProxy::select(string s,string &s2)
{
  Observable::holdObservers();
  // context.superGraph=superGraph;
  context.propertyProxy=this;
  String *tmpString=factory.getObject(s,&context);
  bool result;
  if (tmpString!=NULL)
    {
      result=tmpString->check(s2);
      if (result)
	{
	  if (currentString!=NULL) delete currentString;
	  currentString=tmpString;
	  changeCurrentProperty(currentString,s);
	  reset();
	  currentString->run();
	}
      else
	delete tmpString;
    }
  else
    {
      s2="Data string enable";
      cerr << s2 << ":" << s <<endl;
      result=true;
    }
  notifyObservers();
  Observable::unholdObservers();
  return result;
}

void StringProxy::reset() 
{
}

void StringProxy::reset_handler()
{
}

//=============================================================================
///Poign permettnet le recompute il faut absolument mettre le graphProperties
///currentStringProxy  this sinon le rsultat est imprvisible
void StringProxy::recompute_handler()
{
  superGraph->getPropertyProxyContainer()->currentPropertyProxy=this;
}





