//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include "tulip/SubGraph.h"
#include "tulip/SuperGraph.h"
#include "tulip/SelectionProxy.h"

using namespace std;

//===============================
SubGraph::SubGraph()
{
  father=this;
  associatedGraph=0;
  subGraphProxy=0;
}
SubGraph::~SubGraph()
{
#ifndef NDEBUG
  cerr << "SubGraph::~SubGraph" << endl;
#endif
  list<SubGraph *>::iterator it;
  for (it=subGraphChildList.begin();it!=subGraphChildList.end();++it)
    {
      delete (*it);
    }
  subGraphChildList.clear();
  if (subGraphProxy!=0) delete subGraphProxy;

  //  if (associatedGraph!=0)
  //  delete associatedGraph;
#ifndef NDEBUG
  cerr << "SubGraph::~SubGraph Ok..." << endl;
#endif
}
//===============================
void SubGraph::setAssociatedSuperGraph(SuperGraph *sg)
{
  associatedGraph=sg;
}
SuperGraph *SubGraph::getAssociatedSuperGraph()
{
  return associatedGraph;
}
//===============================  
list<SubGraph *> * SubGraph::getSubGraphChildren()
{return &subGraphChildList;}
//===============================  
SelectionProxy *SubGraph::getSubGraphProxy() const
{return subGraphProxy;}
//===============================
SubGraph *SubGraph::getFather()
{return father;}
//===============================
string SubGraph::getName()
{return name;}
//===============================
void SubGraph::setSubGraphProxy(SelectionProxy *sP)
{ subGraphProxy=sP;}
//===============================
void SubGraph::setFather(SubGraph *p)
{father=p;}
//===============================
void SubGraph::setName(string s)
{name=s;}
//===============================
void SubGraph::addSubGraphChild(SubGraph *p)
{subGraphChildList.push_back(p);}
//===============================
void SubGraph::subSubGraphChild(SubGraph *p)
{ 
  subGraphChildList.remove(p);
  delete p;
}
//===============================
























