#include <stdio.h>
#include <math.h>
#include <sstream>

#include <tulip/SuperGraph.h>
#include <tulip/SelectionProxy.h>
#include <tulip/SubGraph.h>

#include "EqualValueClustering.h"

CLUSTERINGPLUGIN(EqualValueClustering,"Equal Value","David Auber","13/06/2001","Alpha","0","1");

using namespace std;
//================================================================================
EqualValueClustering::EqualValueClustering(ClusterContext context):Clustering(context)
{}
//================================================================================
EqualValueClustering::~EqualValueClustering()
{}

namespace STL_EXT_NS {
  struct hash<double> {
    size_t operator()(const double s) const { return (size_t)s; }
  };
};

//===============================================================================
bool EqualValueClustering::run() {
  string tmp1,tmp2;
  PropertyProxyContainer *ppC=superGraph->getPropertyProxyContainer();
  MetricProxy *metric=getProxy<MetricProxy>(superGraph,"viewMetric");
  
  STL_EXT_NS::hash_map<double,int> partitions;
  int curPart=0;
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    double tmp=metric->getNodeValue(itn);
    if (partitions.find(tmp)==partitions.end()) {
      partitions[tmp]=curPart;
      curPart++;
    }
  } delete itN;
  
  SelectionProxy *selection =getLocalProxy<SelectionProxy>(superGraph,"tmp select");
  selection->setAllNodeValue(false);
  selection->setAllEdgeValue(false);
  map <int,SuperGraph *> newClusters;
  char str[100];
  for (int i=0;i<curPart;++i) {
    sprintf(str,"Cluster_%05i",i);
    newClusters[i]=superGraph->addView(str,selection)->getAssociatedSuperGraph();
  }
  
  itN=superGraph->getNodes();
  for (;itN->hasNext();) {
    node itn=itN->next();
    double tmp=metric->getNodeValue(itn);
    newClusters[partitions[tmp]]->addNode(itn);
  }delete itN;

  Iterator<edge> *itE=superGraph->getEdges();
  for(;itE->hasNext();) {
    edge ite=itE->next();
    double tmp;
    if ((tmp=metric->getNodeValue(superGraph->source(ite)))==metric->getNodeValue(superGraph->target(ite))) {
      newClusters[partitions[tmp]]->addEdge(ite);
    }
  }delete itE;

  ppC->delLocalProxy("tmp select");
  return true;
}
//================================================================================
bool EqualValueClustering::check(string &erreurMsg)
{
  erreurMsg="";
  return true;
}
//================================================================================
void EqualValueClustering::reset()
{
}
//================================================================================




