//-*-c++-*-
#ifndef _GeometricClustering_H
#define _GeometricClustering_H

#include <tulip/TulipPlugin.h>

class MetricProxy;

class GeometricClustering:public Clustering
{ 
public:
  GeometricClustering(ClusterContext);
  ~GeometricClustering();
  bool run();
  bool check(std::string &);
  void reset();
  std::vector<double> *getHistogram();
  void setParameters(int histosize,int threshold,int width);
  void getParameters(int &histosize,int &threshold,int &width);
  void buildResult(STL_EXT_NS::hash_map<node, std::vector<int> > &);
  void autoSetParameter();  
  std::list<int> getLocalMinimum();
private:
  std::vector<double> smoothHistogram;
  std::map<int,int> histogramOfValues;
  int histosize,threshold,width;
  MetricProxy *metric;
};

#endif





