#include <math.h>
#include <stdio.h>
#include <sstream>
#include <string>
#include <list>

#include <tulip/SuperGraph.h>
#include <tulip/SelectionProxy.h>
#include <tulip/SubGraph.h>

#include "SizeNClustering.h"

CLUSTERINGPLUGIN(SizeNClustering,"Size N Clustering","David Auber","27/01/2000","Alpha","0","1");

using namespace std;

class LessThanNodeX
{
public:
  MetricProxy *metric;
  bool operator() (node n1,node n2)
  {
    return (metric->getNodeValue(n1) > metric->getNodeValue(n2));
  } 
};

double min(double i1,double i2)
{
  if (i1<i2) return i1; else return i2;
}

class LessThanEdgeX
{
public:
  MetricProxy *metric;
  SuperGraph *sp;
  bool operator() (edge e1,edge e2)
  {
    return (
	    min(metric->getNodeValue(sp->target(e1)),metric->getNodeValue(sp->source(e1)))
	    <
	    min(metric->getNodeValue(sp->target(e2)),metric->getNodeValue(sp->source(e2))));
  } 
};


//================================================================================
SizeNClustering::SizeNClustering(ClusterContext context):Clustering(context)
{}
//================================================================================
SizeNClustering::~SizeNClustering()
{}
//================================================================================

class LessThan
{
public:
  MetricProxy *metric;
  bool operator() (node n1,node n2)
  {
    return (metric->getNodeValue(n1) < metric->getNodeValue(n2));
  } 
};

//================================================================================
bool SizeNClustering::run()
{


  //Building of orderer list of edges and nodes
  list<node> orderedNode;
  list<edge> orderedEdge;
  list<node>::iterator drawNodesIteratorStl;
  list<edge>::reverse_iterator drawEdgesIteratorStl;
  PropertyProxyContainer *ppC=superGraph->getPropertyProxyContainer();
  MetricProxy *metric=getProxy<MetricProxy>(superGraph,"viewMetric");
  orderedNode.clear();
  Iterator<node> *itN=superGraph->getNodes();
  for (;itN->hasNext();) orderedNode.push_back(itN->next());
  delete itN;
  LessThanNodeX comp;
  comp.metric=metric;
  orderedNode.sort(comp);
  orderedEdge.clear();
  Iterator<edge> *itE=superGraph->getEdges();
  for (;itE->hasNext();) orderedEdge.push_back(itE->next());
  delete itE;
  LessThanEdgeX comp2;
  comp2.metric=metric;
  comp2.sp=superGraph;
  orderedEdge.sort(comp2);

  char str[100];
  int maxEdges=100;
  SelectionProxy *selection =getLocalProxy<SelectionProxy>(superGraph,"tmp select");
  selection->setAllNodeValue(false);
  selection->setAllEdgeValue(false);
  for (int i=0;i<superGraph->numberOfEdges()/maxEdges;++i)
    {
      SuperGraph* tmpSuper;
      sprintf(str,"Cluster_%05i",i);
      tmpSuper=superGraph->addView(str,selection)->getAssociatedSuperGraph();
      drawEdgesIteratorStl=orderedEdge.rbegin();
      for (int j=0;j<(i+1)*maxEdges;++j,++drawEdgesIteratorStl)
	{
	  if (drawEdgesIteratorStl==orderedEdge.rend()) break;
	  tmpSuper->addNode(superGraph->source(*drawEdgesIteratorStl));
	  tmpSuper->addNode(superGraph->target(*drawEdgesIteratorStl));
	  tmpSuper->addEdge(*drawEdgesIteratorStl);
	}
    }
  ppC->delLocalProxy("tmp select");
  return true;
}
//================================================================================
bool SizeNClustering::check(string &erreurMsg)
{
  erreurMsg="";
  return true;
}
//================================================================================
void SizeNClustering::reset()
{
}
//================================================================================




