#include <iostream>

#include <tulip/TypeConverter.h>
#include <tulip/TulipPlugin.h>
#include <tulip/SubGraph.h>
#include <tulip/Cluster.h>

using namespace std;

struct Generic:public ExportModule
{
  Generic(ClusterContext context):ExportModule(context) {}
  ~Generic(){}

  bool exportGraph(ostream &os,SuperGraph *currentGraph) {
    MetricProxy  *metric = getProxy<MetricProxy>(currentGraph,"viewMetric");  
    StringProxy  *stringProxy = getProxy<StringProxy>(currentGraph,"viewLabel");  
    Iterator<node> *itN=currentGraph->getNodes();
    string separator=" ";
    if (itN->hasNext()){
      for (;itN->hasNext();){
	node itn=itN->next();
	os << itn.id << separator;
	os << stringProxy->getNodeValue(itn) << separator;
	os << metric->getNodeValue(itn);
	if (itN->hasNext()) os << endl;
      }
    }delete itN;
    return true;
  }
};
EXPORTPLUGIN(Generic,"Generic","Auber David","10/12/2001","0","0","1")
