//-*-c++-*-
/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 01/05/2002
 This program is free software; you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif
#include <iostream>

#include <tulip/TypeConverter.h>
#include <tulip/TulipPlugin.h>
#include <tulip/SubGraph.h>
#include <tulip/Cluster.h>
#include <tulip/Coord.h>

using namespace std;

struct TLP:public ExportModule {

  DataSet displaying;
  
  TLP(ClusterContext context):ExportModule(context)
  {
    addParameter<DataSet>("displaying");
    
    if (dataSet != NULL) {
      dataSet->get<DataSet>("displaying", displaying);
    } //endif dataSet != NULL
  }
  
  ~TLP(){}
  
  void saveClusterInfo(ostream &os,SubGraph *p) {
    SuperGraph *curCluster=p->getAssociatedSuperGraph();
    os << "(cluster " << curCluster->getId() << " \"" << p->getName() << "\"" << endl;
    Iterator<node> *itN=curCluster->getNodes();
    if (itN->hasNext()) {
      os << "\t(nodes ";
      for (;itN->hasNext();) {
	node itn=itN->next();
	os << itn.id << ' ' ;
      }
      os << ')' << endl;
    }delete itN;
    Iterator<edge> *itE=curCluster->getEdges();
    if (itE->hasNext()) {
      os << "\t(edges ";
      for (;itE->hasNext();) {
	edge ite=itE->next();
	os << ite.id << ' ' ;
      }
      os << ')' << endl;
    }delete itE;
    list<SubGraph *>::iterator itLP;
    for (itLP=p->getSubGraphChildren()->begin();itLP!=p->getSubGraphChildren()->end();++itLP) {
      saveClusterInfo(os,(*itLP));
    }
    os << ")" << endl;
  }
  void saveLocalProperties(ostream &os,SuperGraph *sg) {
    Iterator<string> *itS=sg->getPropertyProxyContainer()->getLocalProperties();
    PProxy *pproxy;
    for (;itS->hasNext();) {
      string its=itS->next();
      pproxy=sg->getPropertyProxyContainer()->getLocalProxy(its);
      if (sg->getFather()==sg)
	os << "(property " << " 0 " << propertyType(pproxy) << " " ;
      else
	os << "(property " << " " << sg->getId() << " " << propertyType(pproxy) << " " ;
      os << "\"" << its << "\"" << endl;
      string nDefault=propertyNodeDefaultValue(pproxy);
      string eDefault=propertyEdgeDefaultValue(pproxy);
      os <<"(default \"" << nDefault << "\" \"" << eDefault << "\" )" << endl; 
      Iterator<node> *itN=sg->getNodes();
      for (;itN->hasNext();) {
	node itn=itN->next();
	string tmp=nodePropertyToString(pproxy,itn);
	if (strcmp(tmp.c_str(),nDefault.c_str())!=0) os << "(node " << itn.id << " \"" << tmp << "\")" << endl ;
      }delete itN;
      Iterator<edge> *itE=sg->getEdges();
      for (;itE->hasNext();) {
	edge ite=itE->next();
	string tmp=edgePropertyToString(pproxy,ite);
	if (strcmp(tmp.c_str(),eDefault.c_str())!=0) os << "(edge " << ite.id << " \"" << tmp << "\")" << endl ;
      }delete itE;
      os << ")" << endl;
    }
    delete itS;
  }
  void saveClusterProperties(ostream &os,SubGraph *p) {
    SuperGraph *curCluster=p->getAssociatedSuperGraph();
    saveLocalProperties(os,curCluster);
    list<SubGraph *>::iterator itLP;
    for (itLP=p->getSubGraphChildren()->begin();itLP!=p->getSubGraphChildren()->end();++itLP) {
      saveClusterProperties(os,(*itLP));
    }
  }

  void saveDisplaying(ostream &os, DataSet &data) {
    os << "(displaying " << endl;
    
    STL_EXT_NS::hash_map<int, string, STL_EXT_NS::hash<int> > glyphTable;
    if (data.get<STL_EXT_NS::hash_map<int, string, STL_EXT_NS::hash<int> > >("glyphTable", glyphTable)) {
      for(STL_EXT_NS::hash_map<int, string, STL_EXT_NS::hash<int> >::const_iterator i = glyphTable.begin(); i != glyphTable.end(); ++i) {
	os << "(glyph " << i->first << " (plugin \"" << i->second << "\"))" << endl;
      }
    }

    Color colorVal;
    string colorList[] = {"backgroundColor"};
    for (int i=0; i<1; ++i) {
      if (data.get<Color>(colorList[i], colorVal)) {
	os << "(color \"" << colorList[i] << "\"";
	os << " \"(" << (int)colorVal.getR() << "," << (int)colorVal.getG() << "," << (int)colorVal.getB() << ",0)\")" << endl;
      }
    }
    
    bool boolVal;
    string boolList[] = {"_viewArrow", "_viewLabel", "_viewKey", "_viewStrahler",
			 "_viewAutoScale", "_incrementalRendering", "_edgeColorInterpolate", "_edge3D"};
    for (int i=0; i < 8; ++i) {
      if (data.get<bool>(boolList[i], boolVal))
	os << "(bool \"" << boolList[i] << "\" " << (boolVal ? "true" : "false") << ")" << endl;
    }

    unsigned int uintVal;
    string uintList[]={"_viewColorEntry", "_viewOrtho", "_FontsType" };
    for (int i=0; i<3; ++i) {
      if (data.get<unsigned int>(uintList[i], uintVal))
	  os << "(uint \"" << uintList[i] << "\" " << uintVal << ")" << endl;
    }

    int intVal;
    string intList[]={"SupergraphId"};
    for (int i=0; i<1; ++i) {
      if (data.get<int>(intList[i], intVal))
	os << "(int \"" << intList[i] << "\" " << intVal << ")" << endl;
    }
    
    Coord coordVal;
    string coordList[] = {"sceneTranslation", "sceneRotation", "cameraEyes", "cameraCenter", "cameraUp"};
    for (int i=0; i<5; ++i) {
      if (data.get<Coord>(coordList[i], coordVal)) {
	os << "(coord \"" << coordList[i] << "\"";
	os << " \"(" << coordVal.getX() << "," << coordVal.getY() << "," << coordVal.getZ() << ")\")" << endl;
      }
    }

    double doubleVal;
    if (data.get<double>("cameraZoomFactor", doubleVal)) {
      os << "(double \"cameraZoomFactor\" " << doubleVal << ")" << endl;
    }

    float floatVal;
    if (data.get<float>("distCam", floatVal)) {
      os << "(float \"distCam\" " << floatVal << ")" << endl;
    }
    
    os << ")" << endl;
  }
  
  bool exportGraph(ostream &os,SuperGraph *currentGraph) {
    Cluster *myCluster=superGraph->getClusterTree();
    SubGraph* currentSubGraph=myCluster->getRootSubGraph();
    superGraph=currentSubGraph->getAssociatedSuperGraph();
    //Save Nodes    
    Iterator<node> *itN=superGraph->getNodes();
    if (itN->hasNext()) {
      os << "(nodes ";
      for (;itN->hasNext();) {
	node itn=itN->next();
	os << itn.id << ' ' ;
      }
      os << ')' << endl;
    }delete itN;
    //Save edges
    Iterator<edge> *itE=superGraph->getEdges();
    for (;itE->hasNext();) {
      edge ite=itE->next();
      os << "(edge " << ite.id << ' ' << superGraph->source(ite).id << ' ' 
	 << superGraph->target(ite).id << ')' << endl;
    }delete itE;
    //Save Clusters Structure
    list<SubGraph *>::iterator itLP;
    for (itLP=currentSubGraph->getSubGraphChildren()->begin();itLP!=currentSubGraph->getSubGraphChildren()->end();++itLP) {
      saveClusterInfo(os,(*itLP));
    } 
    //Save graph properties
    saveLocalProperties(os,superGraph);
    //Save clusters properties
    for (itLP=currentSubGraph->getSubGraphChildren()->begin();itLP!=currentSubGraph->getSubGraphChildren()->end();++itLP) {
      saveClusterProperties(os,(*itLP));
    }

    //Save displaying
    DataSet displaying;
    if (dataSet->get<DataSet>("displaying", displaying))
      saveDisplaying(os, displaying);
    
    //os << ')' << endl;
    return true;
  }
};

EXPORTPLUGIN(TLP,"tlp","Auber David","31/07/2001","0","1","0");
