#include <GL/gl.h>
#include <GL/glut.h>
#include <cmath>

#include <tulip/StringProxy.h>
#include <tulip/ColorsProxy.h>

#include <tulip/Glyph.h>
#include <tulip/SuperGraph.h>
#include <tulip/GlGraph.h>

using namespace std;

class CubeOutLined : public Glyph {
public:
  CubeOutLined(GlyphContext *gc=NULL);
  virtual ~CubeOutLined();
  virtual string getName() {return string("CubeOutLined");}
  virtual void draw(node n);
  virtual Coord getAnchor(const Coord &vector) const;

private:
  GLuint LList;
  bool listOk;
  void drawCube();
};

GLYPHPLUGIN(CubeOutLined, "CubeOutLined", "Bertrand Mathieu", "09/07/2002", "Textured cubeOutLined", "1", "1");

//===================================================================================
CubeOutLined::CubeOutLined(GlyphContext *gc): Glyph(gc),listOk(false) {
}

CubeOutLined::~CubeOutLined() {
  glDeleteLists(LList, 1);
}

void
CubeOutLined::draw(node n) {
  setMaterial(glGraph->elementColor->getNodeValue(n));
  string texFile = glGraph->elementTexture->getNodeValue(n);
  if (texFile != "") {
    if (glGraph->activateTexture(texFile))
      setMaterial(Color(255,255,255,0));
  }
  if (!listOk) {
    LList = glGenLists( 1 );
    glNewList( LList, GL_COMPILE ); 
    drawCube();
    setMaterial(Color(0,0,0,255));
    glutWireCube(1);
    glEndList();
    listOk=true;
  }
  glCallList(LList);
}

Coord CubeOutLined::getAnchor(const Coord &vector) const
{
  Coord anchor = vector;
  anchor *= ( 0.866025 / anchor.norm());

  float x,y,z,fx,fy,fz;
  anchor.get(x,y,z);
  fx=fabsf(x); fy=fabsf(y); fz=fabsf(z);

  if (fx > 0.5) {
    bool adjust=true;
    
    if (fy < fx) anchor.setY((y*0.5)/fx);
    else adjust=false;    
    if (fz < fx) anchor.setZ((z*0.5)/fx);
    else adjust=false;
    
    if (adjust) anchor.setX(x/fx * 0.5); // x = +- 0.5
  }

  if (fy > 0.5) {
    bool adjust=true;
    
    if (fx < fy) anchor.setX((x*0.5)/fy);
    else adjust=false;
    
    if (fz < fy) anchor.setZ((z*0.5)/fy);
    else adjust=false;
    
    if (adjust) anchor.setY(y/fy * 0.5); // y = +- 0.5
  }

  if (fz > 0.5) {
    bool adjust=true;
    
    if (fx < fz) anchor.setX((x*0.5)/fz);
    else adjust=false;
    
    if (fy < fz) anchor.setY((y*0.5)/fz);
    else adjust=false;
    
    if (adjust) anchor.setZ(z/fz * 0.5); // y = +- 0.5
  }

  return anchor;
}

void CubeOutLined::drawCube()
{
  glBegin(GL_QUADS);
  /* front face */
  glNormal3f(0.0f, 0.0f, 1.0f);
  glTexCoord2f(0.0f, 0.0f);
  glVertex3f(-0.5f, -0.5f, 0.5f); 
  glTexCoord2f(1.0f, 0.0f);
  glVertex3f(0.5f, -0.5f, 0.5f);
  glTexCoord2f(1.0f, 1.0f);
  glVertex3f(0.5f, 0.5f, 0.5f);
  glTexCoord2f(0.0f, 1.0f);
  glVertex3f(-0.5f, 0.5f, 0.5f);
  /* back face */
  glNormal3f(0.0f, 0.0f, -1.0f);
  glTexCoord2f(1.0f, 0.0f);
  glVertex3f(-0.5f, -0.5f, -0.5f); 
  glTexCoord2f(1.0f, 1.0f);
  glVertex3f(-0.5f, 0.5f, -0.5f);
  glTexCoord2f(0.0f, 1.0f);
  glVertex3f(0.5f, 0.5f, -0.5f);
  glTexCoord2f(0.0f, 0.0f);
  glVertex3f(0.5f, -0.5f, -0.5f);
  /* right face */
  glNormal3f(1.0f, 0.0f, 0.0f);
  glTexCoord2f(1.0f, 0.0f);
  glVertex3f(0.5f, -0.5f, -0.5f); 
  glTexCoord2f(1.0f, 1.0f);
  glVertex3f(0.5f, 0.5f, -0.5f);
  glTexCoord2f(0.0f, 1.0f);
  glVertex3f(0.5f, 0.5f, 0.5f);
  glTexCoord2f(0.0f, 0.0f);
  glVertex3f(0.5f, -0.5f, 0.5f);
  /* left face */
  glNormal3f(-1.0f, 0.0f, 0.0f);
  glTexCoord2f(1.0f, 0.0f);
  glVertex3f(-0.5f, -0.5f, 0.5f); 
  glTexCoord2f(1.0f, 1.0f);
  glVertex3f(-0.5f, 0.5f, 0.5f);
  glTexCoord2f(0.0f, 1.0f);
  glVertex3f(-0.5f, 0.5f, -0.5f);
  glTexCoord2f(0.0f, 0.0f);
  glVertex3f(-0.5f, -0.5f, -0.5f);
  /* top face */
  glNormal3f(0.0f, 1.0f, 0.0f);
  glTexCoord2f(1.0f, 0.0f);
  glVertex3f(0.5f, 0.5f, 0.5f); 
  glTexCoord2f(1.0f, 1.0f);
  glVertex3f(0.5f, 0.5f, -0.5f);
  glTexCoord2f(0.0f, 1.0f);
  glVertex3f(-0.5f, 0.5f, -0.5f);
  glTexCoord2f(0.0f, 0.0f);
  glVertex3f(-0.5f, 0.5f, 0.5f);
  /* bottom face */
  glNormal3f(0.0f, -1.0f, 0.0f);
  glTexCoord2f(1.0f, 0.0f);
  glVertex3f(0.5f, -0.5f, -0.5f); 
  glTexCoord2f(1.0f, 1.0f);
  glVertex3f(0.5f, -0.5f, 0.5f);
  glTexCoord2f(0.0f, 1.0f);
  glVertex3f(-0.5f, -0.5f, 0.5f);
  glTexCoord2f(0.0f, 0.0f);
  glVertex3f(-0.5f, -0.5f, -0.5f);
  glEnd();

}
