#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct edgeS {
  unsigned  source,target;
};

namespace std {
  struct less<edgeS>
  {
    bool operator()(const edgeS &c,const edgeS &d) const
    {
      if (c.source<d.source) return true;
      if (c.source>d.source) return false;
      if (c.target<d.target) return true;
      if (c.target>d.target) return false;
      return false;
    }
  };
};

struct CirculantGraph:public ImportModule
{
  CirculantGraph(ClusterContext context):ImportModule(context) {}
  ~CirculantGraph(){}
  
  bool import(const string &name) {
    bool ok=true;
    int l = QInputDialog::getInteger( QString("Please enter the rope number"),QString("Rope"), 0, 0, 1000000, 1, &ok );
    if (!ok) return false;
    int numberOFNodes = QInputDialog::getInteger( QString("Please enter the number of nodes"), QString("Number of nodes"), 0 , 0, 1000000,1, &ok );
    if (!ok) return false;
    vector<node> tmp(numberOFNodes);
    for (int i=0;i<numberOFNodes;++i) {
      tmp[i]=superGraph->addNode();
    }
    for (int i=0;i<numberOFNodes;++i) {
      for (int j=1;j<l;++j)
	superGraph->addEdge(tmp[i],tmp[(i+j)%numberOFNodes]);
    }
    return true;
  }
};
IMPORTPLUGIN(CirculantGraph,"Circulant Graph","Auber","16/06/2002","0","0","1")
