#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct edgeS {
  unsigned  source,target;
};

namespace std {
  struct less<edgeS>
  {
    bool operator()(const edgeS &c,const edgeS &d) const
    {
      if (c.source<d.source) return true;
      if (c.source>d.source) return false;
      if (c.target<d.target) return true;
      if (c.target>d.target) return false;
      return false;
    }
  };
};

struct RandomGraph:public ImportModule
{
  RandomGraph(ClusterContext context):ImportModule(context) {}
  ~RandomGraph(){}
  
  bool import(const string &name) {
    timeb tmp;
    ftime(&tmp);
    srand(tmp.time); 
    bool ok=true;
    int resMin = QInputDialog::getInteger( QString("Please enter the number of nodes of the graph "),QString("Number of nodes"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int resMax = QInputDialog::getInteger( QString("Please enter the number of edges"), QString("Number of edges"), 0 , 0, 1000000,10, &ok );
    if (resMax>resMin*resMin) resMax=resMin*resMin;
    if (!ok) return false;
    int ite=resMax*resMin;
    int nbEdges=0;

    set<edgeS> myGraph;

    while (ite>0) {
      if (ite%resMin==1) if (!pluginProgress->progress(resMax*resMin-ite,resMax*resMin)) return false;
      edgeS tmp;
      tmp.source=rand()%resMin;
      tmp.target=rand()%resMin;
      if (myGraph.find(tmp)!=myGraph.end()) {
	myGraph.erase(tmp);
	nbEdges--;
      }
      else {
	if (nbEdges<resMax) {myGraph.insert(tmp);nbEdges++;}
      }
      ite--;
    }
    
    vector<node> tmpVect(resMin);
    for (int i=0;i<resMin;++i) {
      tmpVect[i]=superGraph->addNode();
    }
    
    set<edgeS>::iterator it;
    for (it=myGraph.begin();it!=myGraph.end();++it)   {
      superGraph->addEdge(tmpVect[(*it).source],tmpVect[(*it).target]);
    }
    return true;
  }
};
IMPORTPLUGIN(RandomGraph,"Random General Graph","Auber","16/06/2002","0","0","1")
