#include <sys/timeb.h>
#include<qinputdialog.h>
#include <tulip/TulipPlugin.h>

using namespace std;

struct edgeS {
  unsigned  source,target;
};

namespace std {
  struct less<edgeS> {
    bool operator()(const edgeS &c,const edgeS &d) const {
      int cs,ct,ds,dt;
      if (c.source<=c.target) { 
	cs=c.source;ct=c.target;
      }
      else {
	ct=c.source;cs=c.target;
      }
      if (d.source<=d.target) {
	ds=d.source;dt=d.target;
      }
      else {
	dt=d.source;ds=d.target;
      }
      if (cs<ds) return true;
      if (cs>ds) return false;
      if (ct<dt) return true;
      if (ct>dt) return false;
      return false;
    }
  };
};

struct RandomSimpleGraph:public ImportModule {
  RandomSimpleGraph(ClusterContext context):ImportModule(context) {}
  ~RandomSimpleGraph(){}
  
  bool import(const string &name) {
    timeb tmp;
    ftime(&tmp);
    srand(tmp.time); 
    bool ok=true;
    int numberOfNodes = QInputDialog::getInteger( QString("Please enter the number of nodes of the graph "),QString("Number of nodes"), 0, 0, 1000000, 10, &ok );
    if (!ok) return false;
    int numberOfEdges = QInputDialog::getInteger( QString("Please enter the number of edges"), QString("Number of edges"), 0 , 0, 1000000,10, &ok );
    if (!ok) return false;
    if (numberOfEdges>(numberOfNodes*(numberOfNodes-1)/2)) numberOfEdges=(numberOfNodes*(numberOfNodes-1))/2;
    int ite=numberOfEdges*numberOfNodes;
    int nbEdges=0;
    set<edgeS> myGraph;
    while (ite>0) {
      if (ite%numberOfNodes==1) if (!pluginProgress->progress(numberOfEdges*numberOfNodes-ite,numberOfEdges*numberOfNodes)) return false;
      edgeS tmp;
      tmp.source=rand()%numberOfNodes;
      tmp.target=rand()%numberOfNodes;
      while (tmp.source==tmp.target) {
	tmp.source=rand()%numberOfNodes;
	tmp.target=rand()%numberOfNodes;
      }
      if (myGraph.find(tmp)!=myGraph.end()) {
	myGraph.erase(tmp);
	nbEdges--;
      }
      else {
	if (nbEdges<numberOfEdges) {myGraph.insert(tmp);nbEdges++;}
      }
      ite--;
    }
    vector<node> tmpVect(numberOfNodes);
    for (int i=0;i<numberOfNodes;++i) {
      tmpVect[i]=superGraph->addNode();
    }
    set<edgeS>::iterator it;
    for (it=myGraph.begin();it!=myGraph.end();++it) {
      superGraph->addEdge(tmpVect[(*it).source],tmpVect[(*it).target]);
    }
    return true;
  }
};
IMPORTPLUGIN(RandomSimpleGraph,"Random Simple Graph","Auber","16/06/2002","0","0","1")
