//-*-c++-*-
#ifndef Tulip_GeneralGraph_H
#define Tulip_GeneralGraph_H
#include <tulip/TulipPlugin.h>


class SelfLoops
{
public:
  SelfLoops(node n1,node n2,edge ee1, edge ee2,edge ee3,edge old)
  {
    ghostNode1=n1;
    ghostNode2=n2;
    e1=ee1;
    e2=ee2;
    e3=ee3;
    oldEdge=old;
  }
  ~SelfLoops(){}
  node ghostNode1,ghostNode2;
  edge e1,e2,e3,oldEdge;  
};


struct LR
{
  int L;
  int R;
};
///
class GeneralGraph:public Layout
{ 

public:
  GeneralGraph(PropertyContext *);
  ~GeneralGraph();
  
  bool run();
  void DagLevelSpanningTree(SuperGraph* ,node n);
  void orderedSpanningTree(SuperGraph* ,node n);
  void dfsOrderedSpanningTree(SuperGraph *sg,node n, STL_EXT_NS::hash_map<node,bool> &flag);
  void makeAcyclic(SuperGraph*,std::set<edge> &,std::list<SelfLoops> &);
  node makeSimpleSource(SuperGraph* superGraph);
  void makeProperDag(SuperGraph* superGraph,std::list<node> &, STL_EXT_NS::hash_map<edge,edge> &);
};

#endif










