#include <map>
#include <cmath>
#include <tulip/TulipPlugin.h>

using namespace std;

struct TreeRadial:public Layout {
  TreeRadial(PropertyContext *context):Layout(context)  {}
  void dfsPlacement(node n, int depth,double alphaStart,double alphaEnd) {
    double alpha=(alphaEnd+alphaStart)/2.0;
    if (depth>0) {
      double arcCos=acos((double)depth/((double)(depth+1)));
      if ((alphaEnd-alphaStart)> 2*arcCos) {
	alphaStart=alpha-arcCos;
	alphaEnd=alpha+arcCos;
      }
    } 
    layoutProxy->setNodeValue(n,Coord(((double)depth)*cos(alpha),((double)depth)*sin(alpha),0));
    bool cached,resultBool;
    string erreurMsg;
    MetricProxy *m=getLocalProxy<MetricProxy>(superGraph,"Leaf",cached,resultBool,erreurMsg);
    double sumM=0;
    Iterator<node> *itN=superGraph->getOutNodes(n);
    for (;itN->hasNext();) {
      sumM+=m->getNodeValue(itN->next());
    } delete itN;
    double counto=0;
    double deltaAlpha=2;
    double newAlphaStart;
    double newAlphaEnd;
    if (sumM!=0) {
      deltaAlpha=(alphaEnd-alphaStart)/(sumM);
    }
    itN=superGraph->getOutNodes(n);
    for (;itN->hasNext();) {
      node itn=itN->next();
      newAlphaStart=alphaStart+((double)counto)*deltaAlpha;
      newAlphaEnd=alphaStart+((double)(counto+m->getNodeValue(itn)))*deltaAlpha;
      counto+=m->getNodeValue(itn);
      double sizeTmp=(newAlphaEnd-newAlphaStart)/2*(depth+1);
      if (sizeTmp<0.5) {
	getLocalProxy<SizesProxy>(superGraph,"viewSize")->setNodeValue(itn,Size( sizeTmp , sizeTmp , sizeTmp   ));
      }
      dfsPlacement(itn,depth+1,newAlphaStart,newAlphaEnd);
    } delete itN;
  }
  bool run() {
    Iterator<node> *itN=superGraph->getNodes();
    node startNode;
    for (;itN->hasNext();) {
      startNode=itN->next();
      if (superGraph->indeg(startNode)==0) break;
    } delete itN;
    getLocalProxy<SizesProxy>(superGraph,"viewSize")->setAllNodeValue( Size(0.5,0.5,0.5));
    dfsPlacement(startNode,0,0,6.283);
    superGraph->getPropertyProxyContainer()->delLocalProxy("Leaf");
    return true;
  }
  bool check(string &erreurMsg) {
    if (superGraph->isTree()) {
      erreurMsg="";
      return true;
    }
    else {
      erreurMsg="The Graph must be a Tree";
      return false;
    }
  }
  void reset() {}
};

LAYOUTPLUGIN(TreeRadial,"Tree Radial","David Auber","03/03/2001","Ok","0","1");
