//-*-c++-*-
#ifndef _BarycenterMETRIC_H
#define _BarycenterMETRIC_H

#include <tulip/TulipPlugin.h>
/// ArityMetric.h - Compute the barycenter of each node.
/** This plugin compute the barycenter parameter as published in :
 *
 *  K. Sugiyama and S. Tagawa and M. Toda,
 *  "Methods for Visual Understanding of Hierarchical System Structures",
 *  "IEEE Trans. Systems, Man and Cybernetics",
 *  "109--125", "1981"
 *
 *  HISTORY:
 *
 *  04/10/2001 Verson 0.0.1: Initial release
 *
 *  NOTES:
 *
 *  In order to make up and down layer sweeps the algorithm uses
 *  the DagLevel plug-in to obtain the layer decomposition.
 *  The number of up and down sweeps is fixed two 4.
 *
 *  AUTHOR:
 *
 *  David Auber University Bordeaux I France: Email:auber@tulip-software.com
 *
 *  LICENCE:
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by  
 *  the Free Software Foundation; either version 2 of the License, or     
 *  (at your option) any later version.
 *
 */
class BarycenterMetric:public Metric
{ 
public:
  BarycenterMetric(PropertyContext *);
  ~BarycenterMetric();
  bool run();
  bool check(std::string &);
};

#endif
