#include "PathLengthMetric.h"
METRICPLUGIN(PathLengthMetric,"Path Length","David Auber","15/02/2001","Alpha","0","2");

using namespace std;

PathLengthMetric::PathLengthMetric(PropertyContext *context):Metric(context) {}
PathLengthMetric::~PathLengthMetric() {}
double PathLengthMetric::getNodeValue(const node n)
{
  if (superGraph->outdeg(n)==0) return 0.0;
  bool cached,resultBool;
  string erreurMsg;
  double result=0;
  MetricProxy *leafMetric=getLocalProxy<MetricProxy>(superGraph,"Leaf",cached,resultBool,erreurMsg);
  Iterator<node> *itN=superGraph->getOutNodes(n);
  for (;itN->hasNext();)
    {
      node child=itN->next();
      result+=metricProxy->getNodeValue(child);
    }
  delete itN;
  result+=leafMetric->getNodeValue(n);
  return result;
}
bool PathLengthMetric::check(string &erreurMsg)
{
  if (superGraph->isAcyclic())
      return true;
  else
    {
      erreurMsg="The Graph must be acyclic";
      return false;
    }
}







