/**
 Author: David Auber
 Email : auber@labri.fr
 Last modification : 20/08/2001
 This program is free software; you can redistribute it and/or modify  *
 it under the terms of the GNU General Public License as published by  
 the Free Software Foundation; either version 2 of the License, or     
 (at your option) any later version.
*/

#include <assert.h>
#include "LabelSelection.h"
#include <tulip/SelectionProxy.h>
#include <tulip/MethodFactory.h>
#include <qinputdialog.h>
#include <qstring.h>

SELECTIONPLUGIN(LabelSelection, "Label Selection", "David Auber", "20/01/2003", "Stable", "1", "1");

using namespace std;

LabelSelection::LabelSelection(PropertyContext *context):Selection(context), cancelPressed(false) {}

LabelSelection::~LabelSelection() {
  addParameter<vector<string> *> ("searchStrings");
  addParameter<bool>("searchType");
  addParameter<StringProxy*>("searchLabel");
  searchStrings = NULL;
  stringProxy = NULL;
}

bool LabelSelection::getNodeValue(node n) {
  if (cancelPressed)  //FIXME: ugly workaround, we can't do it another way
    return false;
  
  bool result = searchType;
  string currentString = stringProxy->getNodeValue(n);
  for (unsigned int i=0; i < searchStrings->size(); ++i) {
    if (!searchType) {
      if (currentString.find((*searchStrings)[i], 0) != string::npos) {
	result = true;
	break;
      }
    }
    else if (currentString.find((*searchStrings)[i], 0) == string::npos) {
      result=false;
      break;
    }
  }
  return result;
}

bool LabelSelection::getEdgeValue(edge e) {
  if (cancelPressed)  //FIXME: ugly workaround, we can't do it another way
    return false;
  
  bool result = searchType;
  string currentString = stringProxy->getEdgeValue(e);
  for (unsigned int i=0; i < searchStrings->size(); ++i) {
    if (!searchType) {
      if (currentString.find((*searchStrings)[i], 0) != string::npos) {
	result = true;
	break;
      }
    }
    else if (currentString.find((*searchStrings)[i], 0) == string::npos) {
      result=false;
      break;
    }
  }
  return result;
}

bool LabelSelection::run() {
  searchType = false;
  searchStrings = NULL;
  stringProxy = NULL;
#ifndef NDEBUG
  cerr << __PRETTY_FUNCTION__ << "LabelSelection:" << dataSet << endl;
#endif
  if (dataSet != NULL) {
    dataSet->get("searchStrings", searchStrings);
    dataSet->get("SearchType", searchType);
    dataSet->get("searchLabel", stringProxy);
  }
  
  if (stringProxy == NULL) {
#   ifndef NDEBUG
    cerr << __PRETTY_FUNCTION__ << ": StringProxy == NULL" << endl;
#   endif
    stringProxy=getProxy<StringProxy>(superGraph, "viewLabel");
  }
  
  if (searchStrings == NULL) {
    while (true) {
      bool ok;
      QString text = QInputDialog::getText("Label Selection", "Add a string to search for:",
                                           QLineEdit::Normal, QString::null, &ok);
      if (!ok) {
        cancelPressed = true;
        return false; //cancel pressed
      }
      else if (!text.isEmpty()) {
	searchStringsDefault.push_back(text.latin1());
	searchStrings = &searchStringsDefault;
      }
      else break;
    }
  }
  
  if (searchStrings->size() == 0) return false;
  return true;
}
