#ifndef PROPERTYDIALOG_H // -*-c++-*-
#define PROPERTYDIALOG_H
#include <string>

#include <tulip/SuperGraph.h>
#include <tulip/Observable.h>

#include "PropertyDialogData.h"

class QListViewItem;
class QStringList;

class PProxy;
class GlGraph;
class QScrollBar;
class PropertySlider;

class PropertyDialog : public PropertyDialogData, public Observer
{ 
  Q_OBJECT;

public:
  PropertyDialog(GlGraph *, QWidget *parent = 0, const char *name = 0, bool modal = FALSE, WFlags fl = 0);
  ~PropertyDialog();

private:
  SuperGraph *supergraph;
  GlGraph *glWidget;
  STL_EXT_NS::hash_map<std::string, int> reverseGlyphTable;
  QStringList *glyphList;  //contains glyphs'names, for instanciating QComboTableItems
  PProxy *editedProperty;
  std::string editedPropertyName;
  bool _filterSelection;
  QScrollBar *vScrollNode, *vScrollEdge;
  int vScrollNodePos, vScrollEdgePos;
  int nbNode, nbEdge;
  PropertySlider *propertySliders;
  /// updates nbNode, nbEdge
  void updateNbElements();

public slots:  
  ///Manages observers change notification.
  void update (std::set<Observable *>::iterator, std::set<Observable *>::iterator);
  void selectNode(node);
  void selectEdge(edge);
  void setSuperGraph(SuperGraph *);
  void changePropertyName(QListViewItem *);
  void changePropertyNodeValue(int,int);
  void changePropertyEdgeValue(int,int);
  void newProperty();
  void removeProperty();
  void cloneProperty();
  void filterSelection(bool);
  void setNodeValue();
  void setEdgeValue();
  void scrollNode(int);
  void scrollEdge(int);
  void updateNodes();
  void updateEdges();

protected slots:
  void scaleValuesClicked();
  void propertySliderValueChanged();

signals:
  void tulipNodePropertyChanged(SuperGraph *, const node &, const QString &property, const QString &value);
  void tulipEdgePropertyChanged(SuperGraph *, const edge &, const QString &property, const QString &value);
  
  void tulipAllNodePropertyChanged(SuperGraph *, const QString &property, const QString &value);
  void tulipAllEdgePropertyChanged(SuperGraph *, const QString &property, const QString &value);
};

#endif // PROPERTYDIALOG_H
