//-*-c++-*-
#ifndef VIEW3DSETUP_H
#define VIEW3DSETUP_H
#include <qcolor.h>
#include <string>
#include <tulip/Color.h>

#include "View3DSetupData.h"

class GlGraph;

class View3DSetup : public View3DSetupData
{ 
    Q_OBJECT

public:
    View3DSetup( GlGraph* glWidget,QWidget* parent = 0, const char* name = 0, bool modal = FALSE, WFlags fl = 0 );
    ~View3DSetup();

public :
  bool isAutoMapMetric();
  bool isAutoScale();
  std::string getColorMapping();
  Color getNodeColor();
  Color getEdgeColor();
  
public slots:

  void syncFromGlGraph();
  void backColor();
  void cancelButtonPress();
  void colorNode();
  void colorEdge();
  void okButtonPress();
  void applyButtonPress();
  void setColorMapping(const QString &);
  void setLabels(const QString &);
  void setStrahler(bool);
  void setViewArrow(bool);
  void setViewKey(bool);
  void setViewLabel(bool);
  void setAutoScale(bool);
  void setOrthogonal(bool);
  void setAutoMapMetric(bool);
  void setEdgeColorInterpolation(bool);
  void set3DEdges(bool);
  
private:
  QColor tmpColorBack,tmpColorNode,tmpColorEdge;
  std::string tmpColorMapping;
  bool tmpStrahler,tmpArrow,tmpKey,tmpLabel,tmpAutoScale,tmpOrthogonal, tmp3DEdges;
  bool tmpAutoMapMetric,tmpEdgeColorInterpolation;
  unsigned int tmpFont;
  GlGraph *glWidget;
};

#endif // VIEW3DSETUP_H
