//-*-c++-*-

#ifndef viewGl_included
#define viewGl_included
#include <map>

#if (__GNUC__ < 3)
#include <hash_map>
#else
#include <ext/hash_map>
#endif

#include <vector>
#include <qtooltip.h>
#include <qlistview.h>
#include <qtextview.h> 
#include <qsplitter.h>
#include <qpopupmenu.h>
#include <qmainwindow.h>
#include <pthread.h>

#include <tulip/Reflect.h>
#include <tulip/SuperGraph.h>

class Cluster;
class QWorkspace;
class QProgressDialog;
class QEvent;
class PropertyDialog;
class NavigateGlGraph;
class GlGraphWidget; 
class View3DSetup;
class ClusterTree;
class TulipElementProperties;

///
class myToolTip : public QToolTip
{
  GlGraphWidget *glWidget;
public:
  myToolTip(QWidget* parent = NULL,const char* name=NULL,GlGraphWidget *glWidget = NULL):QToolTip(parent ),
											 glWidget(glWidget){}
  void maybeTip ( const QPoint & );
};


///Widget for manipulation and visualization of a graph
class viewGl : public QMainWindow
{
  Q_OBJECT;

private:

public:
  //
  viewGl(QWidget *parent=NULL, const char *name=NULL , SuperGraph *superGraph=NULL);
  //
  virtual ~viewGl();

  void setParameters(const DataSet);
  const GlGraphWidget *getGlGraphWidget() const;

  bool eventFilter(QObject *, QEvent *);
protected:
  //SuperGraph
  SuperGraph *_superGraph,*_currentGraph;
  ClusterTree *clusterTreeWidget;
  View3DSetup *view3DSetup;
  QWorkspace *workspace;
  QTextView *textView;
  NavigateGlGraph *glWidget1;
  GlGraphWidget *glWidget;
  PropertyDialog *propD;
  TulipElementProperties *nodeProperties;
  
  SubGraph *currentSubGraph;
  QPopupMenu propertyMenu;
  QPopupMenu layoutMenu;
  QPopupMenu metricMenu;
  QPopupMenu colorsMenu;
  QPopupMenu sizesMenu;
  QPopupMenu intMenu;
  QPopupMenu stringMenu;
  QPopupMenu exportGraphMenu;
  QPopupMenu graphMenu;
  QPopupMenu clusteringMenu;
  QPopupMenu optionMenu;
  QPopupMenu viewMenu;
  QPopupMenu selectMenu;
  QPopupMenu editMenu;
  QPopupMenu exportImageMenu;
  QPopupMenu dialogMenu;

  QPopupMenu* windowsMenu;
  void focusInEvent ( QFocusEvent * );


protected slots:
  int  closeWin();
  void changeMetric(int);
  void changeString(int);
  void changeSizes(int);
  void changeColors(int);
  void changeInt(int);
  void changeSelection(int);
  void changeLayout(int);
  void exportGraph(int);
  void exportImage(int);
  void makeClustering(int );
  void outputEPS();
  void showDialog(int);
  void redrawView();
  void centerView();
  void updateSatutBar();
  void deselectALL();
  void reverseSelection();
  void newView();
  void reverseSelectedEdgeDirection();
  void windowsMenuAboutToShow();
  void windowsMenuActivated( int id );
  void restoreView();
  void superGraphAboutToBeRemoved(SuperGraph *);

  void saveDesktopLayout();
protected:

private:

};

#endif // viewGl_included












