//-*-c++-*-
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string>

#include <qpixmap.h>
#include <qmainwindow.h>
#include <qmenubar.h>
#include <qpixmap.h>

#include <tulip/TlpTools.h>
#include <tulip/PluginLoaderTxt.h>
#include <tulip/Coord.h>
#include <tulip/GlGraph.h>
#include <tulip/Glyph.h>
#include <tulip/GlGraphWidget.h>

#include "AppDialog.h"
#include "AppStartUp.h"
#include "Application.h"
#include "viewGl.h"
#include "InfoDialog.h"
#include "ToolBar.h"

#include "QtProgress.h"

using namespace std;

struct PluginLoaderQt:public PluginLoader
{
  AppStartUp *appStartUp;
  int progress;
  virtual void start(const string &path,const string &type) {
    appStartUp->setProgress(0);
    progress=0;
  }
  virtual void numberOfFile(int nbFile) {
    appStartUp->setTotalSteps(nbFile);
    qApp->processEvents();
  }
  virtual void loading(const string &filename){}
  virtual void loaded(const string &name,
		      const string &author,
		      const string &date, 
		      const string &info,
		      const string &release,
		      const string &version)
  {
    progress++;
    appStartUp->setLabel(name);
    appStartUp->setProgress(progress);
    qApp->processEvents();
  }
  virtual void aborted(const string &filename,const  string &erreurmsg) {
    progress++;
    cerr << "Loading error : " << erreurmsg << endl;
    appStartUp->setLabel("Error");
    appStartUp->setProgress(progress);
    qApp->processEvents();
  }
  virtual void finished(bool state,const string &msg){}
};

static void loadPlugins(PluginLoader *plug)
{
  string getEnvVar=TlpTools::TulipLibDir + "/tlp/plugins/";
  
  GlGraph::glyphFactory.load(getEnvVar + "glyph", "Glyph", plug);
}

AppDialog::AppDialog(QWidget* parent,const char* name):QMainWindow( parent, name )
{
#ifdef VERSION
  string tmp("Tulip v.");
  tmp+=VERSION;
  setCaption( tmp.c_str() );
#endif
  QPixmap image0;
  image0.load((((Application *)qApp)->bitmapPath + "logo32x32.bmp").c_str() );
  setIcon( image0 );
  myDialog=new InfoDialog(this);
  fileMenu = new QPopupMenu( this );
  windowMenu = new QPopupMenu( this );
  importMenu = new QPopupMenu( this );
  fileMenu->insertItem( "&New",  this , SLOT(newFile()));
  fileMenu->insertItem("&Import", importMenu );
  connect(importMenu, SIGNAL(activated(int)),SLOT(importGraph(int)));
  fileMenu->insertItem( "&Exit",  this , SLOT(quit()), CTRL+Key_Q );
  windowMenu->insertItem( "&About",  this , SLOT(showInfoDialog()));
  menuBar()->insertItem("&File", fileMenu );
  menuBar()->insertItem("&Window", windowMenu );

  ToolBar* tulipToolBar;
  tulipToolBar = new ToolBar( this, "TulipToolBar" );
  setCentralWidget(tulipToolBar);
  
  int height=tulipToolBar->height();
  height+=menuBar()->height();
  int width=tulipToolBar->width();
  setMaximumSize(width,height);

}

void AppDialog::showInfoDialog() {
 myDialog->show();
}

/*

void AppDialog::openFile() {
  QString s( QFileDialog::getOpenFileName(NULL,QString("*.gml")) );
  if ( s.isNull() )
    return;
  openFile(s.ascii());
}
*/

void AppDialog::openFile(const char *s,const string &plugin) {
  DataSet dataSet;

  StructDef parameter=TlpTools::importFactory.getParam(plugin);
  Iterator<pair<string,string> > *itP=parameter.getField();
  
  for (;itP->hasNext();) {
    pair<string,string> itp=itP->next();
    if (itp.first=="filename"){
      dataSet.set("filename",string(s));
      continue;
    }
  }delete itP;

  string f;
  dataSet.get<string>("filename", f);
  
  MyProgress tmp(this,string("Importing : ")+ s);
  SuperGraph *newSuperGraph=TlpTools::importGraph(plugin, dataSet, &tmp);
  if (newSuperGraph!=0) {
    viewGl *myView=new viewGl(this,s,newSuperGraph);
    ToolBar *toolbar = (ToolBar *) centralWidget();
    const_cast<GlGraphWidget *>(myView->getGlGraphWidget())->setMouse(toolbar->getCurrentMouse());
    connect(toolbar, SIGNAL(mouseChanged(MouseInterface *)), myView->getGlGraphWidget(), SLOT(setMouse(MouseInterface *)));
    DataSet glGraphData;
    if (dataSet.get<DataSet>("displaying", glGraphData))
      myView->setParameters(glGraphData);
    myView->show();
  }
}

void AppDialog::importGraph(int id) {
  string name(importMenu->text(id).ascii());
  StructDef parameter=TlpTools::importFactory.getParam(name);
  QString s=importMenu->text(id);
  Iterator<pair<string,string> > *itP=parameter.getField();
  for (;itP->hasNext();) {
    pair<string,string> itp=itP->next();
    if (itp.first=="filename"){
      s=QFileDialog::getOpenFileName(NULL);
      if (s.isNull()) return;
      continue;
    }
  }delete itP;
  openFile(s.ascii(),name);
}

void AppDialog::newFile() {
  Observable::holdObservers();
  SuperGraph *newSuperGraph=new SuperGraphImpl();
  getProxy<SizesProxy>(newSuperGraph,"viewSize")->setAllNodeValue(Size(1,1,1));
  viewGl *myView=new viewGl(this,"Untitiled Graph",newSuperGraph);
  ToolBar *toolbar = (ToolBar *) centralWidget();
  const_cast<GlGraphWidget *>(myView->getGlGraphWidget())->setMouse(toolbar->getCurrentMouse());
  connect(toolbar, SIGNAL(mouseChanged(MouseInterface *)), myView->getGlGraphWidget(), SLOT(setMouse(MouseInterface *)));
  myView->show();
  Observable::unholdObservers();
}

void AppDialog::initTulip() {
  AppStartUp *myAppStartUp=new AppStartUp();
  myAppStartUp->setTotalSteps(0);
  myAppStartUp->setProgress(0);
  myAppStartUp->setLabel("Tulip");
  myAppStartUp->show();

#ifndef NDEBUG
  PluginLoaderTxt plug;
#else
  PluginLoaderQt plug;
  plug.appStartUp=myAppStartUp;
#endif

  TlpTools::loadPlugins(&plug);   // library side plugins
  loadPlugins(&plug);   // software side plugins, i.e. glyphs
  //
  
  delete myAppStartUp;

  TemplateFactory<ImportModuleFactory,ImportModule,ClusterContext>::ObjectCreator::const_iterator it3;
  for (it3=TlpTools::importFactory.objMap.begin();it3!=TlpTools::importFactory.objMap.end();++it3) {
    importMenu->insertItem( it3->first.c_str() );
  }
}

AppDialog::~AppDialog() {}

void AppDialog::quit() {
  exit(0);
}
