#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <assert.h>
#include <qcursor.h>
#include "NavigateButton.h"

//=====================================================
// Mouse 
//=====================================================
NavigateButton::NavigateButton( QWidget * parent, const char * name, WFlags f):QWidget(parent,name,f)
{
  buttonMouse=NULL;
  buttonGlWidget=NULL;
}
//=====================================================
void NavigateButton::setMouseObject(MouseInterface *mouse)
{
  buttonMouse=mouse;
}
//=====================================================
void NavigateButton::setGlGraphWidget(GlGraphWidget *glWidget)
{
  buttonGlWidget=glWidget;
}
//=====================================================
void NavigateButton::mousePressEvent ( QMouseEvent * e )
{
  assert(buttonMouse!=NULL);
  assert(buttonGlWidget!=NULL);
  this->grabMouse(QCursor());
  (buttonMouse)->mPressEvent(buttonGlWidget ,  e);
}
//================================================
void  NavigateButton::mouseMoveEvent ( QMouseEvent * e )
{
  assert(buttonGlWidget!=NULL);
  assert(buttonMouse!=NULL);
  (buttonMouse)->mMoveEvent(buttonGlWidget ,  e);
}
//================================================
void  NavigateButton::mouseReleaseEvent ( QMouseEvent * e ) 
{
  assert(buttonGlWidget!=NULL);
  assert(buttonMouse!=NULL);
  (buttonMouse)->mReleaseEvent(buttonGlWidget ,  e);
  this->releaseMouse();
}
//=====================================================




