#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <iostream>
#include <cassert>
#include "tulip/GlFonts.h"

using namespace std;


//***************************************************************************
// CLASSE t_GlFonts
//***************************************************************************
//---------------------------------------------------------------------------
t_GlFonts::~t_GlFonts() {
  vector<_GlFonts>::iterator it=fonts.begin();
  for (;it!=fonts.end();++it)
    delete(it->font);
}
//---------------------------------------------------------------------------
int t_GlFonts::searchFont(FontMode type, int size, const string f, float depth) const{
  _GlFonts tmp = _GlFonts(type,size,f,depth);
  map<_GlFonts,int>::const_iterator it=fontsIndex.find(tmp);
  if (it!=fontsIndex.end()) {
    return it->second;
  }
  else
    return -1;
}
//---------------------------------------------------------------------------
int t_GlFonts::Add(FontMode t, int s, float d, const string f) {
  //  cerr << __PRETTY_FUNCTION__ << endl;
  _GlFonts tmp = _GlFonts(t,s,f,d);
  switch(t) {
  case BITMAP:
    tmp.font = new FTGLBitmapFont (f.c_str());
    break;
  case PIXMAP:
    tmp.font = new FTGLPixmapFont (f.c_str());
    break;
  case OUTLINE:
    tmp.font = new FTGLOutlineFont (f.c_str());
    break;
  case POLYGON:
    tmp.font = new FTGLPolygonFont (f.c_str());
    break;
  case EXTRUDE:
    tmp.font = new FTGLExtrdFont (f.c_str());
    break;
  case TEXTURE:
    tmp.font = new FTGLTextureFont (f.c_str());
    break;
  case TLPPIXMAP:
    tmp.font = new TLPPixmapFont (f.c_str());
    break;
  }
  assert(!tmp.font->Error());  
  if (!tmp.font->FaceSize(s))
    cerr << __PRETTY_FUNCTION__ << " FaceSize error" << endl;
  tmp.font->Depth(d);
  if (!tmp.font->CharMap(ft_encoding_unicode))
    cerr << __PRETTY_FUNCTION__ << " CharMap error" << endl; 
  
  fonts.push_back(tmp);
  fontsIndex[tmp] = fonts.size()-1;
  return fonts.size()-1;
}

//---------------------------------------------------------------------------
_GlFonts t_GlFonts::operator[](unsigned int i) const {
  assert (i<fonts.size() && i<-1);
  return fonts[i];
}

//***************************************************************************
// CLASSE _GlFonts
//***************************************************************************
//---------------------------------------------------------------------------
_GlFonts::_GlFonts(FontMode type, int size, const std::string name, float depth) :
  type(type),size(size),file(name),font(0) {
  if (type==EXTRUDE)
    this->depth=depth;
  else
    this->depth=0;
}
bool _GlFonts::operator< (const _GlFonts &dest) const {
  if (type < dest.type) return true;
  if (type > dest.type) return false;
  if (size < dest.size) return true;
  if (size > dest.size) return false;
  if (file < dest.file) return true;
  if (file > dest.file) return false;
  if (depth < dest.depth) return true;
  //  if (depth < dest->depth) return false;  
  return false;
}
//***************************************************************************
//  CLASSE GlFonts
//***************************************************************************
//---------------------------------------------------------------------------
void GlFonts::drawString(const string str, int index) const{
  if(index == -1){
    if(active)
      ftfonts[current_font].font->Render(str.c_str());
    else
      cerr<<" GlFonts warning : drawString, font non active"<<endl;
  }
  else{
    ftfonts[index].font->Render(str.c_str());
  }
}
//--------------------------------------------------------------------------- 
void GlFonts::getBBox(const std::string s, float& x1, float& y1, float& z1, float& x2, float& y2, float& z2){
  getBBox(s.c_str(), x1, y1, z1, x2, y2, z2);
}
//--------------------------------------------------------------------------- 
float GlFonts::getAdvance(const string str, int index) const{
  //  cerr << __PRETTY_FUNCTION__ << " " << index << " " << str << endl;
  if(index == -1){
    if(active)
      return ftfonts[current_font].font->Advance(str.c_str());
    else{
      cerr<<" GlFonts error : getAdvance, probleme d'indice "<<endl;
      return 0;
    }
  }
  else
    return ftfonts[index].font->Advance(str.c_str());
}
//--------------------------------------------------------------------------- 
float GlFonts::getAscender(int index) const{
  if(index == -1){
    if(active)
      return ftfonts[current_font].font->Ascender();
    else
      return 0;
  }
  else{
    return ftfonts[index].font->Ascender();
  }
}
//--------------------------------------------------------------------------- 
float GlFonts::getDescender(int index) const{
  if(index == -1){
    if(active)
      return ftfonts[current_font].font->Descender();
    else
      return 0;
  }
  else{
    return ftfonts[index].font->Descender();
  }
}
//--------------------------------------------------------------------------- 
bool GlFonts::ActiveFont(int index){
  current_font = index;
  active = true;
  return true;
}
//--------------------------------------------------------------------------- 
bool GlFonts::ActiveFont(FontMode t, int s,const string f, float d){
  int val = ftfonts.searchFont(t, s, f, d);
  if(val != -1) return false;
  current_font = val;
  active = true;
  return true;
}

int GlFonts::searchFont(FontMode type, int size, const std::string f, float depth)const {
  return ftfonts.searchFont(type,size,f.c_str(),depth);
}
//--------------------------------------------------------------------------- 
const char* GlFonts::getFontFilename(int index)const{
  if(index == -1){
    if(active)
      return ftfonts[current_font].getFileName();
    else{
      cerr<<" GlFonts error : getFontFilename, font non active "<<endl;
      return 0;      
    }
  }
  else{
    return ftfonts[index].getFileName();
  }
}
//--------------------------------------------------------------------------- 
int GlFonts::getFontType(int index)const{
  if(index == -1){
    if(active)
      return ftfonts[current_font].getType();
    else{
      cerr<<" GlFonts error : getFontType, font non active "<<endl;
      return 0;      
    }
  }
  else{
    return ftfonts[index].getType();
  }
}
//--------------------------------------------------------------------------- 
int GlFonts::AddFont(FontMode type, int size, const string f, float depth){
  //  cerr << __PRETTY_FUNCTION__ << " " << size << " " << f << " " << depth << endl;
  int val = ftfonts.searchFont(type, size, f, depth);
  if(val != -1) {
    cerr << __PRETTY_FUNCTION__ << " Font already loaded" << endl;
    return val;
  } 
  val = ftfonts.Add(type, size, depth, f);  // ne renvoie qu'une valeur juste
  return val;
}
//--------------------------------------------------------------------------- 
