#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <cassert>
#include <iostream>
#include "tulip/ObservableGlGraph.h"

using namespace std;

void ObservableGlGraph::notifyMoveCamera(GlGraph *glGraph) {
  for (set<GlGraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->moveCamera(glGraph);
}

void ObservableGlGraph::notifyMoveObject(GlGraph *glGraph) {
  for (set<GlGraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->moveObject(glGraph);
}

void ObservableGlGraph::notifyDraw(GlGraph *glGraph) {
  for (set<GlGraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->draw(glGraph);
}

void ObservableGlGraph::notifyDestroy(GlGraph *glGraph) {
  for (set<GlGraphObserver *>::iterator itlObs=observers.begin();itlObs!=observers.end();++itlObs)
    (*itlObs)->destroy(glGraph);
}
