#ifndef TULIPELEMENTPROPERTIES_H
#define TULIPELEMENTPROPERTIES_H

#include <qstringlist.h>
#include <qsize.h>

#include <tulip/SuperGraph.h>
#include <tulip/ObservableGraph.h>
#include "TulipElementPropertiesData.h"

class TulipElementProperties : public TulipElementPropertiesData, public GraphObserver
{
  Q_OBJECT;
  // moc as of qt 3.0.5 doesn't understand '::'... silly
  //  Q_ENUMS(Tulip::AtomType);
  //  Q_PROPERTY(Tulip::AtomType displayMode READ getDisplayMode WRITE setDisplayMode);
  Q_PROPERTY(QStringList nodeListedProperties READ getNodeListedProperties WRITE setNodeListedProperties);
  Q_PROPERTY(QStringList edgeListedProperties READ getEdgeListedProperties WRITE setEdgeListedProperties);
  Q_PROPERTY(bool elementDisplayed READ isElementDisplayed);
protected:
  tlp::ElementType displayMode;
  node currentNode;
  edge currentEdge;
  bool nodeSet;
  bool edgeSet;
  bool displayAllProperties;
  SuperGraph *supergraph;
  QStringList nodeListedProperties;
  QStringList edgeListedProperties;

  //inherited slots

  
public:
  TulipElementProperties(SuperGraph *, const QStringList &nodeListedProperties, const QStringList &edgeListedProperties,
                         QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
  TulipElementProperties(QWidget *parent = 0, const char *name = 0, WFlags fl = 0);
  ~TulipElementProperties();
    
  QStringList getCurrentListedProperties() const;
  QStringList getNodeListedProperties() const;
  QStringList getEdgeListedProperties() const;
  SuperGraph *getSuperGraph() const;
  node getCurrentNode() const;
  edge getCurrentEdge() const;
  tlp::ElementType getDisplayMode() const;
  bool isElementDisplayed() const;
  
public slots:
  void updateTable();
  void propertyTableValueChanged(int, int);
  void setDisplayMode(const tlp::ElementType);
  void setCurrentNode(SuperGraph *, const node &);
  void setCurrentEdge(SuperGraph *, const edge &);
  void setSuperGraph(SuperGraph *);
  void setCurrentListedProperties(const QStringList &);
  void setNodeListedProperties(const QStringList &);
  void setEdgeListedProperties(const QStringList &);
  void nodePropertyChanged(SuperGraph *, const node &, const QString &, const QString &);
  void edgePropertyChanged(SuperGraph *, const edge &, const QString &, const QString &);
  
signals:
  void tulipNodePropertyChanged(SuperGraph *, const node &, const QString &property, const QString &value);
  void tulipEdgePropertyChanged(SuperGraph *, const edge &, const QString &property, const QString &value);


 private:
  void delNode(SuperGraph *, node);
  void delEdge(SuperGraph *, edge);
  void destroy(SuperGraph *);
};

#endif //TULIPELEMENTPROPERTIES_H
